/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.taurus.marketdata;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.service.marketdata.MarketDataService;
import org.knowm.xchange.taurus.TaurusExchange;
import org.knowm.xchange.taurus.dto.marketdata.TaurusOrderBook;
import org.knowm.xchange.taurus.service.TaurusMarketDataServiceRaw;

public class TaurusDepthDemo {
    public static void main(String[] args) throws IOException {
        Exchange taurus = ExchangeFactory.INSTANCE.createExchange(TaurusExchange.class.getName());
        MarketDataService marketDataService = taurus.getMarketDataService();
        TaurusDepthDemo.generic(marketDataService);
        TaurusDepthDemo.raw((TaurusMarketDataServiceRaw)marketDataService);
    }

    private static void generic(MarketDataService marketDataService) throws IOException {
        OrderBook orderBook = marketDataService.getOrderBook(CurrencyPair.BTC_CAD, new Object[0]);
        System.out.println("Current Order Book size for BTC / CAD: " + (orderBook.getAsks().size() + orderBook.getBids().size()));
        System.out.println("First Ask: " + ((LimitOrder)orderBook.getAsks().get(0)).toString());
        System.out.println("Last Ask: " + ((LimitOrder)orderBook.getAsks().get(orderBook.getAsks().size() - 1)).toString());
        System.out.println("First Bid: " + ((LimitOrder)orderBook.getBids().get(0)).toString());
        System.out.println("Last Bid: " + ((LimitOrder)orderBook.getBids().get(orderBook.getBids().size() - 1)).toString());
        System.out.println(orderBook.toString());
    }

    private static void raw(TaurusMarketDataServiceRaw marketDataService) throws IOException {
        TaurusOrderBook orderBook = marketDataService.getTaurusOrderBook();
        System.out.println("Current Order Book size for BTC / CAD: " + (orderBook.getAsks().size() + orderBook.getBids().size()));
        System.out.println("First Ask: " + ((List)orderBook.getAsks().get(0)).toString());
        System.out.println("First Bid: " + ((List)orderBook.getBids().get(0)).toString());
        System.out.println(orderBook.toString());
    }
}

