/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.taurus.marketdata;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.service.marketdata.MarketDataService;
import org.knowm.xchange.taurus.TaurusExchange;
import org.knowm.xchange.taurus.dto.marketdata.TaurusTicker;
import org.knowm.xchange.taurus.service.TaurusMarketDataServiceRaw;

public class TaurusTickerDemo {
    public static void main(String[] args) throws IOException {
        Exchange taurus = ExchangeFactory.INSTANCE.createExchange(TaurusExchange.class.getName());
        MarketDataService marketDataService = taurus.getMarketDataService();
        TaurusTickerDemo.generic(marketDataService);
        TaurusTickerDemo.raw((TaurusMarketDataServiceRaw)marketDataService);
    }

    private static void generic(MarketDataService marketDataService) throws IOException {
        Ticker ticker = marketDataService.getTicker(CurrencyPair.BTC_CAD, new Object[0]);
        System.out.println(ticker.toString());
    }

    private static void raw(TaurusMarketDataServiceRaw marketDataService) throws IOException {
        TaurusTicker taurusTicker = marketDataService.getTaurusTicker();
        System.out.println(taurusTicker.toString());
    }
}

