/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.taurus.trade;

import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.examples.taurus.TaurusDemoUtils;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.taurus.dto.trade.TaurusOrder;
import org.knowm.xchange.taurus.service.TaurusTradeServiceRaw;

public class TaurusTradeDemo {
    public static void main(String[] args) throws IOException {
        Exchange taurus = TaurusDemoUtils.createExchange();
        TradeService tradeService = taurus.getTradeService();
        TaurusTradeDemo.generic(tradeService);
        TaurusTradeDemo.raw((TaurusTradeServiceRaw)tradeService);
    }

    private static void generic(TradeService tradeService) throws IOException {
        TaurusTradeDemo.printOpenOrders(tradeService);
        LimitOrder limitOrder = new LimitOrder(Order.OrderType.ASK, new BigDecimal(".01"), CurrencyPair.BTC_CAD, null, null, new BigDecimal("400.00"));
        String limitOrderReturnValue = tradeService.placeLimitOrder(limitOrder);
        System.out.println("Limit Order return value: " + limitOrderReturnValue);
        TaurusTradeDemo.printOpenOrders(tradeService);
        boolean cancelResult = tradeService.cancelOrder(limitOrderReturnValue);
        System.out.println("Canceling returned " + cancelResult);
        TaurusTradeDemo.printOpenOrders(tradeService);
    }

    private static void printOpenOrders(TradeService tradeService) throws IOException {
        OpenOrders openOrders = tradeService.getOpenOrders();
        System.out.println("Open Orders: " + openOrders.toString());
    }

    private static void raw(TaurusTradeServiceRaw tradeService) throws IOException {
        TaurusTradeDemo.printRawOpenOrders(tradeService);
        TaurusOrder order = tradeService.sellTaurusOrder(new BigDecimal("0.01"), new BigDecimal("400.00"));
        System.out.println("TaurusOrder return value: " + order);
        TaurusTradeDemo.printRawOpenOrders(tradeService);
        boolean cancelResult = tradeService.cancelTaurusOrder(order.getId());
        System.out.println("Canceling returned " + cancelResult);
        TaurusTradeDemo.printRawOpenOrders(tradeService);
    }

    private static void printRawOpenOrders(TaurusTradeServiceRaw tradeService) throws IOException {
        TaurusOrder[] openOrders = tradeService.getTaurusOpenOrders();
        System.out.println("Open Orders: " + openOrders.length);
        for (TaurusOrder order : openOrders) {
            System.out.println(order.toString());
        }
    }
}

