/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.taurus.trade;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.examples.taurus.TaurusDemoUtils;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.TradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsSorted;
import org.knowm.xchange.taurus.dto.trade.TaurusUserTransaction;
import org.knowm.xchange.taurus.service.TaurusTradeServiceRaw;

public class TaurusUserTradeHistoryDemo {
    public static void main(String[] args) throws IOException {
        Exchange taurus = TaurusDemoUtils.createExchange();
        TradeService tradeService = taurus.getTradeService();
        TaurusUserTradeHistoryDemo.generic(tradeService);
        TaurusUserTradeHistoryDemo.raw((TaurusTradeServiceRaw)tradeService);
    }

    private static void generic(TradeService tradeService) throws IOException {
        UserTrades trades = tradeService.getTradeHistory(tradeService.createTradeHistoryParams());
        System.out.println(trades);
        TradeHistoryParams params = tradeService.createTradeHistoryParams();
        ((TradeHistoryParamPaging)params).setPageLength(Integer.valueOf(3));
        UserTrades tradesLimitedTo3 = tradeService.getTradeHistory(params);
        System.out.println(tradesLimitedTo3);
    }

    private static void raw(TaurusTradeServiceRaw tradeService) throws IOException {
        TaurusUserTransaction[] transactionLimitedTo3;
        TaurusUserTransaction[] trades;
        for (TaurusUserTransaction trade : trades = tradeService.getTaurusUserTransactions(null, Integer.valueOf(1000), TradeHistoryParamsSorted.Order.asc)) {
            System.out.println(trade);
        }
        for (TaurusUserTransaction tx : transactionLimitedTo3 = tradeService.getTaurusUserTransactions(null, Integer.valueOf(3), null)) {
            System.out.println(tx);
        }
    }
}

