/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.therock.trade;

import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.examples.therock.TheRockExampleUtils;
import org.knowm.xchange.therock.TheRock;
import org.knowm.xchange.therock.dto.trade.TheRockOrder;
import org.knowm.xchange.therock.dto.trade.TheRockOrders;
import org.knowm.xchange.therock.service.TheRockTradeServiceRaw;

public class TheRockTradeRawDemo {
    public static final CurrencyPair BTC_EUR = CurrencyPair.BTC_EUR;

    public static void main(String[] args) throws Exception {
        Exchange theRockExchange = TheRockExampleUtils.createTestExchange();
        TheRockTradeRawDemo.raw(theRockExchange);
    }

    private static void raw(Exchange theRockExchange) throws IOException, InterruptedException {
        TheRockTradeServiceRaw tradeService = (TheRockTradeServiceRaw)theRockExchange.getTradeService();
        BigDecimal amount = new BigDecimal("0.01");
        BigDecimal price = new BigDecimal("50.0");
        TheRock.Pair pair = new TheRock.Pair(BTC_EUR);
        TheRockOrder order = new TheRockOrder(pair, TheRockOrder.Side.buy, TheRockOrder.Type.limit, amount, price);
        TheRockOrder orderResult = tradeService.placeTheRockOrder(BTC_EUR, order);
        TheRockTradeRawDemo.print(orderResult);
        Thread.sleep(3000L);
        orderResult = tradeService.showTheRockOrder(BTC_EUR, orderResult.getId());
        TheRockTradeRawDemo.print(orderResult);
        Thread.sleep(3000L);
        TheRockOrders orders = tradeService.getTheRockOrders(BTC_EUR);
        TheRockTradeRawDemo.print(orders);
        Thread.sleep(3000L);
        TheRockOrders executedOrders = tradeService.getTheRockOrders(BTC_EUR, null, null, "executed", null, null, 1);
        TheRockTradeRawDemo.print(executedOrders);
        Thread.sleep(3000L);
        TheRockOrders execSellOrders = tradeService.getTheRockOrders(BTC_EUR, null, null, "executed", TheRockOrder.Side.sell, null, 1);
        TheRockTradeRawDemo.print(execSellOrders);
        Thread.sleep(3000L);
        tradeService.cancelTheRockOrder(BTC_EUR, orderResult.getId());
        Thread.sleep(3000L);
    }

    private static void print(Object object) {
        System.out.println();
    }
}

