/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.wex.marketdata;

import java.io.IOException;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.service.marketdata.MarketDataService;
import org.knowm.xchange.wex.v3.WexExchange;
import org.knowm.xchange.wex.v3.service.WexMarketDataServiceRaw;

public class WexDepthDemo {
    public static void main(String[] args) throws IOException {
        Exchange btce = ExchangeFactory.INSTANCE.createExchange(WexExchange.class.getName());
        WexDepthDemo.generic(btce);
        WexDepthDemo.raw(btce);
    }

    private static void generic(Exchange exchange) throws IOException {
        MarketDataService marketDataService = exchange.getMarketDataService();
        OrderBook orderBook = marketDataService.getOrderBook(CurrencyPair.LTC_USD, new Object[0]);
        System.out.println(orderBook.toString());
        System.out.println("size: " + (orderBook.getAsks().size() + orderBook.getBids().size()));
        orderBook = marketDataService.getOrderBook(CurrencyPair.BTC_USD, new Object[]{2000});
        System.out.println(orderBook.toString());
        System.out.println("size: " + (orderBook.getAsks().size() + orderBook.getBids().size()));
        orderBook = marketDataService.getOrderBook(CurrencyPair.BTC_USD, new Object[]{3});
        System.out.println(orderBook.toString());
        System.out.println("size: " + (orderBook.getAsks().size() + orderBook.getBids().size()));
    }

    private static void raw(Exchange exchange) throws IOException {
        WexMarketDataServiceRaw marketDataService = (WexMarketDataServiceRaw)exchange.getMarketDataService();
        Map depth = marketDataService.getBTCEDepth("ltc_usd", 7).getDepthMap();
        for (Map.Entry entry : depth.entrySet()) {
            System.out.println("Pair: " + (String)entry.getKey() + ", Depth:" + entry.getValue());
        }
    }
}

