/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.wex.marketdata;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.service.marketdata.MarketDataService;
import org.knowm.xchange.utils.CertHelper;
import org.knowm.xchange.wex.v3.WexExchange;
import org.knowm.xchange.wex.v3.dto.marketdata.WexTickerWrapper;
import org.knowm.xchange.wex.v3.service.WexMarketDataServiceRaw;

public class WexTickerDemo {
    public static void main(String[] args) throws Exception {
        CertHelper.trustAllCerts();
        Exchange btce = ExchangeFactory.INSTANCE.createExchange(WexExchange.class.getName());
        WexTickerDemo.generic(btce);
        WexTickerDemo.raw(btce);
    }

    private static void generic(Exchange exchange) throws IOException {
        MarketDataService marketDataService = exchange.getMarketDataService();
        Ticker ticker = marketDataService.getTicker(CurrencyPair.BTC_USD, new Object[0]);
        System.out.println("Last: " + ticker.getLast().toString());
        System.out.println("Volume: " + ticker.getVolume().toString());
        System.out.println("High: " + ticker.getHigh().toString());
        System.out.println("Low: " + ticker.getLow().toString());
        System.out.println(ticker.toString());
    }

    private static void raw(Exchange exchange) throws IOException {
        WexMarketDataServiceRaw marketDataService = (WexMarketDataServiceRaw)exchange.getMarketDataService();
        WexTickerWrapper ticker = marketDataService.getBTCETicker("btc_usd");
        System.out.println(ticker.toString());
    }
}

