/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.wex.marketdata;

import java.io.IOException;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.service.marketdata.MarketDataService;
import org.knowm.xchange.wex.v3.WexExchange;
import org.knowm.xchange.wex.v3.dto.marketdata.WexTrade;
import org.knowm.xchange.wex.v3.service.WexMarketDataServiceRaw;

public class WexTradesDemo {
    public static void main(String[] args) throws IOException {
        Exchange btce = ExchangeFactory.INSTANCE.createExchange(WexExchange.class.getName());
        WexTradesDemo.generic(btce);
        WexTradesDemo.raw(btce);
    }

    private static void generic(Exchange exchange) throws IOException {
        MarketDataService marketDataService = exchange.getMarketDataService();
        Trades trades = marketDataService.getTrades(CurrencyPair.BTC_EUR, new Object[0]);
        System.out.println(trades.toString());
    }

    private static void raw(Exchange exchange) throws IOException {
        WexMarketDataServiceRaw marketDataService = (WexMarketDataServiceRaw)exchange.getMarketDataService();
        Map trades = marketDataService.getBTCETrades("btc_usd", 7).getTradesMap();
        for (Map.Entry entry : trades.entrySet()) {
            System.out.println("Pair: " + (String)entry.getKey() + ", Trades:");
            for (WexTrade trade : (WexTrade[])entry.getValue()) {
                System.out.println(trade.toString());
            }
        }
    }
}

