/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.latoken;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.InstrumentMetaData;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.latoken.LatokenAdapters;
import org.knowm.xchange.latoken.LatokenAuthenticated;
import org.knowm.xchange.latoken.dto.exchangeinfo.LatokenCurrency;
import org.knowm.xchange.latoken.dto.exchangeinfo.LatokenPair;
import org.knowm.xchange.latoken.service.LatokenAccountService;
import org.knowm.xchange.latoken.service.LatokenMarketDataService;
import org.knowm.xchange.latoken.service.LatokenTradeService;
import org.knowm.xchange.utils.AuthUtils;
import si.mazi.rescu.SynchronizedValueFactory;

public class LatokenExchange
extends BaseExchange {
    private static final int PRECISION = 8;
    private LatokenAuthenticated latoken;

    protected void initServices() {
        this.latoken = (LatokenAuthenticated)ExchangeRestProxyBuilder.forInterface(LatokenAuthenticated.class, (ExchangeSpecification)this.getExchangeSpecification()).build();
        this.marketDataService = new LatokenMarketDataService((Exchange)this);
        this.tradeService = new LatokenTradeService((Exchange)this);
        this.accountService = new LatokenAccountService((Exchange)this);
    }

    public SynchronizedValueFactory<Long> getNonceFactory() {
        throw new UnsupportedOperationException("Latoken uses HMAC signature and timing-validation rather than a nonce");
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification spec = new ExchangeSpecification(((Object)((Object)this)).getClass());
        spec.setSslUri("https://api.latoken.com");
        spec.setHost("www.latoken.com");
        spec.setPort(80);
        spec.setExchangeName("Latoken");
        spec.setExchangeDescription("LATOKEN Exchange.");
        AuthUtils.setApiAndSecretKey((ExchangeSpecification)spec, (String)"latoken");
        return spec;
    }

    public void remoteInit() {
        try {
            Map currenciesMetaData = this.exchangeMetaData.getCurrencies();
            Map pairsMetaData = this.exchangeMetaData.getInstruments();
            List<LatokenPair> allPairs = this.latoken.getAllPairs();
            List<LatokenCurrency> allCurrencies = this.latoken.getAllCurrencies();
            this.exchangeSpecification.setExchangeSpecificParametersItem("pairs", allPairs);
            for (LatokenCurrency latokenCurrency : allCurrencies) {
                Currency currency = LatokenAdapters.adaptCurrency(latokenCurrency);
                this.addCurrencyMetadata(currenciesMetaData, currency, 8);
            }
            for (LatokenPair latokenPair : allPairs) {
                CurrencyPair pair = LatokenAdapters.adaptCurrencyPair(latokenPair);
                InstrumentMetaData pairMetadata = LatokenAdapters.adaptPairMetaData(latokenPair);
                this.addCurrencyPairMetadata(pairsMetaData, pair, pairMetadata);
            }
        }
        catch (Exception e) {
            throw new ExchangeException("Failed to initialize: " + e.getMessage(), (Throwable)e);
        }
    }

    private void addCurrencyMetadata(Map<Currency, CurrencyMetaData> currencies, Currency currency, int precision) {
        CurrencyMetaData baseMetaData = currencies.get(currency);
        BigDecimal withdrawalFee = baseMetaData == null ? null : baseMetaData.getWithdrawalFee();
        currencies.put(currency, new CurrencyMetaData(Integer.valueOf(precision), withdrawalFee));
    }

    private void addCurrencyPairMetadata(Map<Instrument, InstrumentMetaData> pairs, CurrencyPair pair, InstrumentMetaData pairMetadata) {
        InstrumentMetaData baseMetaData = pairs.get(pair);
        BigDecimal maxAmount = baseMetaData == null ? pairMetadata.getMaximumAmount() : baseMetaData.getMaximumAmount();
        pairs.put((Instrument)pair, new InstrumentMetaData.Builder().tradingFee(pairMetadata.getTradingFee()).minimumAmount(pairMetadata.getMinimumAmount()).maximumAmount(maxAmount).priceScale(pairMetadata.getPriceScale()).build());
    }
}

