/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.latoken.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Date;
import org.knowm.xchange.latoken.dto.trade.LatokenOrderSide;

public class LatokenTrade {
    private final LatokenOrderSide side;
    private final BigDecimal price;
    private final BigDecimal amount;
    private final Date timestamp;

    public LatokenTrade(@JsonProperty(value="side") String side, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="timestamp") long timestamp) {
        this.side = LatokenOrderSide.parse(side);
        this.price = price;
        this.amount = amount;
        this.timestamp = new Date(timestamp);
    }

    public LatokenOrderSide getSide() {
        return this.side;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "LatokenTrade [side = " + (Object)((Object)this.side) + ", price = " + this.price + ", amount = " + this.amount + ", timestamp = " + this.timestamp + "]";
    }
}

