/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.latoken.dto.trade;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Date;
import org.knowm.xchange.latoken.dto.trade.LatokenNewOrder;
import org.knowm.xchange.latoken.dto.trade.LatokenOrderStatus;

public final class LatokenOrder
extends LatokenNewOrder {
    private final LatokenOrderStatus latokenOrderStatus;
    private final BigDecimal executedAmount;
    private final BigDecimal reaminingAmount;
    private final Date timeCreated;
    private final Date timeFilled;

    public LatokenOrder(@JsonProperty(value="orderId") String orderId, @JsonProperty(value="cliOrdId") String clientOrderId, @JsonProperty(value="pairId") long pairId, @JsonProperty(value="symbol") String symbol, @JsonProperty(value="side") String side, @JsonProperty(value="orderType") String type, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="orderStatus") String orderStatus, @JsonProperty(value="executedAmount") BigDecimal executedAmount, @JsonProperty(value="reaminingAmount") BigDecimal reaminingAmount, @JsonProperty(value="timeCreated") long timeCreated, @JsonProperty(value="timeFilled") long timeFilled) {
        super(orderId, clientOrderId, pairId, symbol, side, type, price, amount);
        this.latokenOrderStatus = LatokenOrderStatus.parse(orderStatus);
        this.executedAmount = executedAmount;
        this.reaminingAmount = reaminingAmount;
        this.timeCreated = new Date(timeCreated);
        this.timeFilled = new Date(timeFilled);
    }

    public LatokenOrderStatus getOrderStatus() {
        return this.latokenOrderStatus;
    }

    public BigDecimal getExecutedAmount() {
        return this.executedAmount;
    }

    public BigDecimal getReaminingAmount() {
        return this.reaminingAmount;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeFilled() {
        return this.timeFilled;
    }

    @Override
    public String toString() {
        return "LatokenOrder [latokenOrderStatus = " + (Object)((Object)this.latokenOrderStatus) + ", executedAmount = " + this.executedAmount + ", reaminingAmount = " + this.reaminingAmount + ", timeCreated = " + this.timeCreated + ", timeFilled = " + this.timeFilled + super.toString() + "]";
    }
}

