/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.latoken.dto.trade;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Date;
import org.knowm.xchange.latoken.dto.trade.LatokenOrderSide;

public class LatokenUserTrade {
    private final String id;
    private final String orderId;
    private final BigDecimal fee;
    private final LatokenOrderSide side;
    private final BigDecimal price;
    private final BigDecimal amount;
    private final Date time;

    public LatokenUserTrade(@JsonProperty(value="id") String id, @JsonProperty(value="orderId") String orderId, @JsonProperty(value="commission") BigDecimal fee, @JsonProperty(value="side") String side, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="low") BigDecimal amount, @JsonProperty(value="time") long time) {
        this.id = id;
        this.orderId = orderId;
        this.fee = fee;
        this.side = LatokenOrderSide.parse(side);
        this.price = price;
        this.amount = amount;
        this.time = new Date(time);
    }

    public String getId() {
        return this.id;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public BigDecimal getFee() {
        return this.fee;
    }

    public LatokenOrderSide getSide() {
        return this.side;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Date getTime() {
        return this.time;
    }

    public String toString() {
        return "LatokenUserTrade [id = " + this.id + ", orderId = " + this.orderId + ", fee = " + this.fee + ", side = " + (Object)((Object)this.side) + ", price = " + this.price + ", amount = " + this.amount + ", time = " + this.time + "]";
    }
}

