/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.oer.service;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.oer.OERAdapters;
import org.knowm.xchange.oer.dto.marketdata.OERRates;
import org.knowm.xchange.oer.service.OERMarketDataServiceRaw;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class OERMarketDataService
extends OERMarketDataServiceRaw
implements MarketDataService {
    public OERMarketDataService(Exchange exchange) {
        super(exchange);
    }

    public Ticker getTicker(CurrencyPair currencyPair, Object ... args) throws IOException {
        OERRates rates = this.getOERTicker(currencyPair);
        Method method = null;
        try {
            method = OERRates.class.getMethod("get" + currencyPair.counter.getCurrencyCode(), null);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new ExchangeException("Problem getting exchange rate!", (Throwable)e);
        }
        Double exchangeRate = null;
        try {
            exchangeRate = (Double)method.invoke((Object)rates, null);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new ExchangeException("Problem getting exchange rate!", (Throwable)e);
        }
        return OERAdapters.adaptTicker(currencyPair, exchangeRate);
    }

    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public Trades getTrades(CurrencyPair currencyPair, Object ... args) throws IOException {
        throw new NotAvailableFromExchangeException();
    }
}

