/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.oer.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.oer.OER;
import org.knowm.xchange.oer.dto.marketdata.OERRates;
import org.knowm.xchange.oer.dto.marketdata.OERTickers;
import org.knowm.xchange.oer.service.OERBaseService;

public class OERMarketDataServiceRaw
extends OERBaseService {
    private final OER openExchangeRates;

    public OERMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
        this.openExchangeRates = (OER)ExchangeRestProxyBuilder.forInterface(OER.class, (ExchangeSpecification)exchange.getExchangeSpecification()).build();
    }

    public OERRates getOERTicker(CurrencyPair pair) throws IOException {
        OERTickers oERTickers = this.openExchangeRates.getTickers(this.exchange.getExchangeSpecification().getApiKey(), pair.base.toString(), pair.counter.toString());
        if (oERTickers == null) {
            throw new ExchangeException("Null response returned from Open Exchange Rates!");
        }
        return oERTickers.getRates();
    }
}

