/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.bitfinex;

import info.bitrich.xchangestream.bitfinex.BitfinexStreamingAccountService;
import info.bitrich.xchangestream.bitfinex.BitfinexStreamingMarketDataService;
import info.bitrich.xchangestream.bitfinex.BitfinexStreamingService;
import info.bitrich.xchangestream.bitfinex.BitfinexStreamingTradeService;
import info.bitrich.xchangestream.core.ProductSubscription;
import info.bitrich.xchangestream.core.StreamingExchange;
import info.bitrich.xchangestream.service.netty.NettyStreamingService;
import io.reactivex.Completable;
import io.reactivex.Observable;
import org.apache.commons.lang3.StringUtils;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.bitfinex.BitfinexExchange;
import si.mazi.rescu.SynchronizedValueFactory;

public class BitfinexStreamingExchange
extends BitfinexExchange
implements StreamingExchange {
    static final String API_URI = "wss://api.bitfinex.com/ws/2";
    private BitfinexStreamingService streamingService;
    private BitfinexStreamingMarketDataService streamingMarketDataService;
    private BitfinexStreamingTradeService streamingTradeService;
    private BitfinexStreamingAccountService streamingAccountService;

    protected void initServices() {
        super.initServices();
        this.streamingService = this.createStreamingService();
        this.streamingMarketDataService = new BitfinexStreamingMarketDataService(this.streamingService);
        this.streamingTradeService = new BitfinexStreamingTradeService(this.streamingService);
        this.streamingAccountService = new BitfinexStreamingAccountService(this.streamingService);
    }

    private BitfinexStreamingService createStreamingService() {
        BitfinexStreamingService streamingService = new BitfinexStreamingService(API_URI, (SynchronizedValueFactory<Long>)this.getNonceFactory());
        this.applyStreamingSpecification(this.getExchangeSpecification(), (NettyStreamingService)streamingService);
        if (StringUtils.isNotEmpty((CharSequence)this.exchangeSpecification.getApiKey())) {
            streamingService.setApiKey(this.exchangeSpecification.getApiKey());
            streamingService.setApiSecret(this.exchangeSpecification.getSecretKey());
        }
        return streamingService;
    }

    public Completable connect(ProductSubscription ... args) {
        return this.streamingService.connect();
    }

    public Completable disconnect() {
        return this.streamingService.disconnect();
    }

    public boolean isAlive() {
        return this.streamingService.isSocketOpen();
    }

    public Observable<Throwable> reconnectFailure() {
        return this.streamingService.subscribeReconnectFailure();
    }

    public Observable<Object> connectionSuccess() {
        return this.streamingService.subscribeConnectionSuccess();
    }

    public Observable<Object> connectionIdle() {
        return this.streamingService.subscribeIdle();
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification spec = super.getDefaultExchangeSpecification();
        spec.setShouldLoadRemoteMetaData(false);
        return spec;
    }

    public BitfinexStreamingMarketDataService getStreamingMarketDataService() {
        return this.streamingMarketDataService;
    }

    public BitfinexStreamingAccountService getStreamingAccountService() {
        return this.streamingAccountService;
    }

    public BitfinexStreamingTradeService getStreamingTradeService() {
        return this.streamingTradeService;
    }

    public void useCompressedMessages(boolean compressedMessages) {
        this.streamingService.useCompressedMessages(compressedMessages);
    }

    public boolean isAuthenticatedAlive() {
        return this.streamingService != null && this.streamingService.isAuthenticated();
    }
}

