/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.bitfinex;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import info.bitrich.xchangestream.bitfinex.BitfinexStreamingAdapters;
import info.bitrich.xchangestream.bitfinex.dto.BitfinexAuthRequestStatus;
import info.bitrich.xchangestream.bitfinex.dto.BitfinexWebSocketAuth;
import info.bitrich.xchangestream.bitfinex.dto.BitfinexWebSocketAuthBalance;
import info.bitrich.xchangestream.bitfinex.dto.BitfinexWebSocketAuthOrder;
import info.bitrich.xchangestream.bitfinex.dto.BitfinexWebSocketAuthPreTrade;
import info.bitrich.xchangestream.bitfinex.dto.BitfinexWebSocketAuthTrade;
import info.bitrich.xchangestream.bitfinex.dto.BitfinexWebSocketSubscriptionMessage;
import info.bitrich.xchangestream.bitfinex.dto.BitfinexWebSocketUnSubscriptionMessage;
import info.bitrich.xchangestream.service.netty.JsonNettyStreamingService;
import info.bitrich.xchangestream.service.netty.StreamingObjectMapperHelper;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandler;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.PublishSubject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringUtils;
import org.knowm.xchange.exceptions.ExchangeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.SynchronizedValueFactory;

public class BitfinexStreamingService
extends JsonNettyStreamingService {
    private static final Logger LOG = LoggerFactory.getLogger(BitfinexStreamingService.class);
    static final String CHANNEL_USER_POSITIONS = "userPositions";
    static final String CHANNEL_USER_BALANCE_UPDATES = "userBalanceUpdates";
    static final String CHANNEL_USER_BALANCES = "userBalances";
    static final String CHANNEL_USER_ORDER_UPDATES = "userOrderUpdates";
    static final String CHANNEL_USER_ORDERS = "userOrders";
    static final String CHANNEL_USER_TRADES = "userTrades";
    static final String CHANNEL_USER_PRE_TRADES = "userPreTrades";
    private static final String INFO = "info";
    private static final String ERROR = "error";
    private static final String CHANNEL_ID = "chanId";
    private static final String SUBSCRIBED = "subscribed";
    private static final String UNSUBSCRIBED = "unsubscribed";
    private static final String ERROR_CODE = "code";
    private static final String AUTH = "auth";
    private static final String STATUS = "status";
    private static final String MESSAGE = "msg";
    private static final String EVENT = "event";
    private static final String VERSION = "version";
    private static final int CALCULATION_BATCH_SIZE = 8;
    private static final List<String> WALLETS = Arrays.asList("exchange", "margin", "funding");
    private final PublishSubject<BitfinexWebSocketAuthPreTrade> subjectPreTrade = PublishSubject.create();
    private final PublishSubject<BitfinexWebSocketAuthTrade> subjectTrade = PublishSubject.create();
    private final PublishSubject<BitfinexWebSocketAuthOrder> subjectOrder = PublishSubject.create();
    private final PublishSubject<BitfinexWebSocketAuthBalance> subjectBalance = PublishSubject.create();
    private static final int SUBSCRIPTION_FAILED = 10300;
    private static final int SUBSCRIPTION_DUP = 10301;
    private String apiKey;
    private String apiSecret;
    private final Map<String, String> subscribedChannels = new HashMap<String, String>();
    private final SynchronizedValueFactory<Long> nonceFactory;
    private final BlockingQueue<String> calculationQueue = new LinkedBlockingQueue<String>();
    private Disposable calculator;

    public BitfinexStreamingService(String apiUrl, SynchronizedValueFactory<Long> nonceFactory) {
        super(apiUrl, Integer.MAX_VALUE, DEFAULT_CONNECTION_TIMEOUT, DEFAULT_RETRY_DURATION, 30);
        this.nonceFactory = nonceFactory;
    }

    public Completable connect() {
        return super.connect().doOnComplete(() -> {
            this.calculator = Observable.interval((long)1L, (TimeUnit)TimeUnit.SECONDS).subscribe(x -> this.requestCalcs());
        });
    }

    public Completable disconnect() {
        if (this.calculator != null) {
            this.calculator.dispose();
        }
        return super.disconnect();
    }

    protected WebSocketClientExtensionHandler getWebSocketClientExtensionHandler() {
        return null;
    }

    public boolean processArrayMassageSeparately() {
        return false;
    }

    protected void handleMessage(JsonNode message) {
        String type;
        if (message.isArray() && (type = message.get(1).asText()).equals("hb")) {
            return;
        }
        JsonNode event = message.get(EVENT);
        if (event != null) {
            switch (event.textValue()) {
                case "info": {
                    JsonNode version = message.get(VERSION);
                    if (version != null) {
                        LOG.debug("Bitfinex websocket API version: {}.", (Object)version.intValue());
                    }
                    if (!this.isAuthenticated()) break;
                    this.auth();
                    break;
                }
                case "auth": {
                    if (message.get(STATUS).textValue().equals(BitfinexAuthRequestStatus.FAILED.name())) {
                        LOG.error("Authentication error: {}", (Object)message.get(MESSAGE));
                    }
                    if (!message.get(STATUS).textValue().equals(BitfinexAuthRequestStatus.OK.name())) break;
                    LOG.info("Authenticated successfully");
                    break;
                }
                case "subscribed": {
                    String channel = message.get("channel").asText();
                    String pair = message.get("pair").asText();
                    String channelId = message.get(CHANNEL_ID).asText();
                    try {
                        String subscriptionUniqueId = this.getSubscriptionUniqueId(channel, pair);
                        this.subscribedChannels.put(channelId, subscriptionUniqueId);
                        LOG.debug("Register channel {}: {}", (Object)subscriptionUniqueId, (Object)channelId);
                    }
                    catch (Exception e) {
                        LOG.error(e.getMessage());
                    }
                    break;
                }
                case "unsubscribed": {
                    String channelId = message.get(CHANNEL_ID).asText();
                    this.subscribedChannels.remove(channelId);
                    break;
                }
                case "error": {
                    if (message.get(ERROR_CODE).asInt() == 10300) {
                        LOG.error("Error with message: " + message.get("symbol") + " " + message.get(MESSAGE));
                        return;
                    }
                    if (message.get(ERROR_CODE).asInt() == 10301) {
                        LOG.warn("Already subscribed: " + message.toString());
                        return;
                    }
                    super.handleError((Object)message, (Throwable)new ExchangeException("Error code: " + message.get(ERROR_CODE).asText()));
                }
            }
        } else {
            try {
                if ("0".equals(this.getChannelNameFromMessage(message)) && message.isArray() && message.size() == 3) {
                    this.processAuthenticatedMessage(message);
                    return;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to get channel name from message", e);
            }
            super.handleMessage((Object)message);
        }
    }

    private void processAuthenticatedMessage(JsonNode message) {
        String type = message.get(1).asText();
        JsonNode object = message.get(2);
        switch (type) {
            case "te": {
                BitfinexWebSocketAuthPreTrade preTrade = BitfinexStreamingAdapters.adaptPreTrade(object);
                if (preTrade == null) break;
                this.subjectPreTrade.onNext((Object)preTrade);
                break;
            }
            case "tu": {
                BitfinexWebSocketAuthTrade trade = BitfinexStreamingAdapters.adaptTrade(object);
                if (trade == null) break;
                this.subjectTrade.onNext((Object)trade);
                break;
            }
            case "os": {
                BitfinexStreamingAdapters.adaptOrders(object).forEach(arg_0 -> this.subjectOrder.onNext(arg_0));
                break;
            }
            case "on": 
            case "ou": 
            case "oc": {
                BitfinexWebSocketAuthOrder order = BitfinexStreamingAdapters.adaptOrder(object);
                if (order == null) break;
                this.subjectOrder.onNext((Object)order);
                break;
            }
            case "ws": {
                BitfinexStreamingAdapters.adaptBalances(object).forEach(arg_0 -> this.subjectBalance.onNext(arg_0));
                break;
            }
            case "wu": {
                BitfinexWebSocketAuthBalance balance = BitfinexStreamingAdapters.adaptBalance(object);
                if (balance == null) break;
                this.subjectBalance.onNext((Object)balance);
                break;
            }
            case "bu": {
                break;
            }
            default: {
                LOG.debug("Unknown Bitfinex authenticated message type {}. Content={}", (Object)type, (Object)object);
            }
        }
    }

    public String getSubscriptionUniqueId(String channelName, Object ... args) {
        if (args.length > 0) {
            return channelName + "-" + args[0].toString();
        }
        return channelName;
    }

    protected String getChannelNameFromMessage(JsonNode message) throws IOException {
        String chanId = null;
        if (message.has(CHANNEL_ID)) {
            chanId = message.get(CHANNEL_ID).asText();
        } else {
            JsonNode jsonNode = message.get(0);
            if (jsonNode != null) {
                chanId = message.get(0).asText();
            }
        }
        if (chanId == null) {
            throw new IOException("Can't find CHANNEL_ID value in socket message: " + message.toString());
        }
        String subscribedChannel = this.subscribedChannels.get(chanId);
        if (subscribedChannel != null) {
            return subscribedChannel;
        }
        return chanId;
    }

    public String getSubscribeMessage(String channelName, Object ... args) throws IOException {
        BitfinexWebSocketSubscriptionMessage subscribeMessage = null;
        if (args.length == 1) {
            subscribeMessage = new BitfinexWebSocketSubscriptionMessage(channelName, (String)args[0]);
        } else if (args.length == 3) {
            subscribeMessage = new BitfinexWebSocketSubscriptionMessage(channelName, (String)args[0], (String)args[1], (String)args[2]);
        }
        if (subscribeMessage == null) {
            throw new IOException("SubscribeMessage: Insufficient arguments");
        }
        return this.objectMapper.writeValueAsString((Object)subscribeMessage);
    }

    public String getUnsubscribeMessage(String channelName) throws IOException {
        String channelId = null;
        for (Map.Entry<String, String> entry : this.subscribedChannels.entrySet()) {
            if (!entry.getValue().equals(channelName)) continue;
            channelId = entry.getKey();
            break;
        }
        if (channelId == null) {
            throw new IOException("Can't find channel unique name");
        }
        BitfinexWebSocketUnSubscriptionMessage subscribeMessage = new BitfinexWebSocketUnSubscriptionMessage(channelId);
        ObjectMapper objectMapper = StreamingObjectMapperHelper.getObjectMapper();
        return objectMapper.writeValueAsString((Object)subscribeMessage);
    }

    void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    void setApiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
    }

    boolean isAuthenticated() {
        return StringUtils.isNotEmpty((CharSequence)this.apiKey);
    }

    private void auth() {
        String signature;
        long nonce = (Long)this.nonceFactory.createValue();
        String payload = "AUTH" + nonce;
        try {
            Mac macEncoder = Mac.getInstance("HmacSHA384");
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.apiSecret.getBytes(StandardCharsets.UTF_8), "HmacSHA384");
            macEncoder.init(secretKeySpec);
            byte[] result = macEncoder.doFinal(payload.getBytes(StandardCharsets.UTF_8));
            signature = DatatypeConverter.printHexBinary((byte[])result);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            LOG.error("auth. Sign failed error={}", (Object)e.getMessage());
            return;
        }
        BitfinexWebSocketAuth message = new BitfinexWebSocketAuth(this.apiKey, payload, String.valueOf(nonce), signature.toLowerCase());
        this.sendObjectMessage(message);
    }

    Observable<BitfinexWebSocketAuthOrder> getAuthenticatedOrders() {
        return this.subjectOrder.share();
    }

    Observable<BitfinexWebSocketAuthPreTrade> getAuthenticatedPreTrades() {
        return this.subjectPreTrade.share();
    }

    Observable<BitfinexWebSocketAuthTrade> getAuthenticatedTrades() {
        return this.subjectTrade.share();
    }

    Observable<BitfinexWebSocketAuthBalance> getAuthenticatedBalances() {
        return this.subjectBalance.share();
    }

    void scheduleCalculatedBalanceFetch(String currency) {
        LOG.debug("Scheduling request for full calculated balances for: {}", (Object)currency);
        this.calculationQueue.add(currency);
    }

    /*
     * Exception decompiling
     */
    private void requestCalcs() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

