/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.bitfinex.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexTicker;

@JsonFormat(shape=JsonFormat.Shape.ARRAY)
public class BitfinexWebSocketTickerTransaction {
    public String channelId;
    public String[] tickerArr;

    public BitfinexWebSocketTickerTransaction() {
    }

    public BitfinexWebSocketTickerTransaction(String channelId, String[] tickerArr) {
        this.channelId = channelId;
        this.tickerArr = tickerArr;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public BitfinexTicker toBitfinexTicker() {
        BigDecimal bid = new BigDecimal(this.tickerArr[0]);
        BigDecimal ask = new BigDecimal(this.tickerArr[2]);
        BigDecimal mid = ask.subtract(bid);
        BigDecimal low = new BigDecimal(this.tickerArr[9]);
        BigDecimal high = new BigDecimal(this.tickerArr[8]);
        BigDecimal last = new BigDecimal(this.tickerArr[6]);
        double timestamp = System.currentTimeMillis() / 1000L;
        BigDecimal volume = new BigDecimal(this.tickerArr[7]);
        return new BitfinexTicker(mid, bid, ask, low, high, last, timestamp, volume);
    }
}

