/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;

public class ProductSubscription {
    private final List<CurrencyPair> orderBook;
    private final List<CurrencyPair> trades;
    private final List<CurrencyPair> ticker;
    private final List<CurrencyPair> userTrades;
    private final List<CurrencyPair> orders;
    private final List<Currency> balances;

    private ProductSubscription(ProductSubscriptionBuilder builder) {
        this.orderBook = this.asList(builder.orderBook);
        this.trades = this.asList(builder.trades);
        this.ticker = this.asList(builder.ticker);
        this.orders = this.asList(builder.orders);
        this.userTrades = this.asList(builder.userTrades);
        this.balances = this.asList(builder.balances);
    }

    private <T> List<T> asList(Iterable<T> collection) {
        ArrayList result = new ArrayList();
        collection.forEach(result::add);
        return Collections.unmodifiableList(result);
    }

    public List<CurrencyPair> getOrderBook() {
        return this.orderBook;
    }

    public List<CurrencyPair> getTrades() {
        return this.trades;
    }

    public List<CurrencyPair> getTicker() {
        return this.ticker;
    }

    public List<CurrencyPair> getOrders() {
        return this.orders;
    }

    public List<CurrencyPair> getUserTrades() {
        return this.userTrades;
    }

    public List<Currency> getBalances() {
        return this.balances;
    }

    public boolean isEmpty() {
        return !this.hasAuthenticated() && !this.hasUnauthenticated();
    }

    public boolean hasAuthenticated() {
        return !this.orders.isEmpty() || !this.userTrades.isEmpty() || !this.balances.isEmpty();
    }

    public boolean hasUnauthenticated() {
        return !this.ticker.isEmpty() || !this.trades.isEmpty() || !this.orderBook.isEmpty();
    }

    public static ProductSubscriptionBuilder create() {
        return new ProductSubscriptionBuilder();
    }

    public static class ProductSubscriptionBuilder {
        private final Set<CurrencyPair> orderBook = new HashSet<CurrencyPair>();
        private final Set<CurrencyPair> trades = new HashSet<CurrencyPair>();
        private final Set<CurrencyPair> ticker = new HashSet<CurrencyPair>();
        private final Set<CurrencyPair> userTrades;
        private final Set<CurrencyPair> orders = new HashSet<CurrencyPair>();
        private final Set<Currency> balances;

        private ProductSubscriptionBuilder() {
            this.userTrades = new HashSet<CurrencyPair>();
            this.balances = new HashSet<Currency>();
        }

        public ProductSubscriptionBuilder addOrderbook(CurrencyPair pair) {
            this.orderBook.add(pair);
            return this;
        }

        public ProductSubscriptionBuilder addTrades(CurrencyPair pair) {
            this.trades.add(pair);
            return this;
        }

        public ProductSubscriptionBuilder addTicker(CurrencyPair pair) {
            this.ticker.add(pair);
            return this;
        }

        public ProductSubscriptionBuilder addOrders(CurrencyPair pair) {
            this.orders.add(pair);
            return this;
        }

        public ProductSubscriptionBuilder addUserTrades(CurrencyPair pair) {
            this.userTrades.add(pair);
            return this;
        }

        public ProductSubscriptionBuilder addBalances(Currency pair) {
            this.balances.add(pair);
            return this;
        }

        public ProductSubscriptionBuilder addAll(CurrencyPair pair) {
            this.orderBook.add(pair);
            this.trades.add(pair);
            this.ticker.add(pair);
            this.orders.add(pair);
            this.userTrades.add(pair);
            this.balances.add(pair.base);
            this.balances.add(pair.counter);
            return this;
        }

        public ProductSubscription build() {
            return new ProductSubscription(this);
        }
    }
}

