/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.core;

import info.bitrich.xchangestream.core.ProductSubscription;
import info.bitrich.xchangestream.core.StreamingAccountService;
import info.bitrich.xchangestream.core.StreamingMarketDataService;
import info.bitrich.xchangestream.core.StreamingTradeService;
import info.bitrich.xchangestream.service.netty.NettyStreamingService;
import io.netty.channel.ChannelHandlerContext;
import io.reactivex.Completable;
import io.reactivex.Observable;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;

public interface StreamingExchange
extends Exchange {
    public static final String USE_SANDBOX = "Use_Sandbox";
    public static final String ACCEPT_ALL_CERITICATES = "Accept_All_Ceriticates";
    public static final String ENABLE_LOGGING_HANDLER = "Enable_Logging_Handler";
    public static final String SOCKS_PROXY_HOST = "SOCKS_Proxy_Host";
    public static final String SOCKS_PROXY_PORT = "SOCKS_Proxy_Port";
    public static final String AUTO_RECONNECT = "Auto_Reconnect";
    public static final String L3_ORDERBOOK = "L3_Orderbook";

    public Completable connect(ProductSubscription ... var1);

    public Completable disconnect();

    public boolean isAlive();

    default public Observable<Throwable> reconnectFailure() {
        throw new NotYetImplementedForExchangeException();
    }

    default public Observable<Object> connectionSuccess() {
        throw new NotYetImplementedForExchangeException();
    }

    default public Observable<ChannelHandlerContext> disconnectObservable() {
        throw new NotYetImplementedForExchangeException();
    }

    default public Observable<Long> messageDelay() {
        throw new NotYetImplementedForExchangeException();
    }

    default public void resubscribeChannels() {
        throw new NotYetImplementedForExchangeException();
    }

    default public Observable<Object> connectionIdle() {
        throw new NotYetImplementedForExchangeException();
    }

    public StreamingMarketDataService getStreamingMarketDataService();

    default public StreamingAccountService getStreamingAccountService() {
        throw new NotYetImplementedForExchangeException();
    }

    default public StreamingTradeService getStreamingTradeService() {
        throw new NotYetImplementedForExchangeException();
    }

    public void useCompressedMessages(boolean var1);

    default public void applyStreamingSpecification(ExchangeSpecification exchangeSpec, NettyStreamingService<?> streamingService) {
        Boolean autoReconnect;
        Boolean enable_logging_handler;
        streamingService.setSocksProxyHost((String)exchangeSpec.getExchangeSpecificParametersItem(SOCKS_PROXY_HOST));
        streamingService.setSocksProxyPort((Integer)exchangeSpec.getExchangeSpecificParametersItem(SOCKS_PROXY_PORT));
        streamingService.setBeforeConnectionHandler((Runnable)exchangeSpec.getExchangeSpecificParametersItem("Before_Connection_Event_Handler"));
        Boolean accept_all_ceriticates = (Boolean)exchangeSpec.getExchangeSpecificParametersItem(ACCEPT_ALL_CERITICATES);
        if (accept_all_ceriticates != null && accept_all_ceriticates.booleanValue()) {
            streamingService.setAcceptAllCertificates(true);
        }
        if ((enable_logging_handler = (Boolean)exchangeSpec.getExchangeSpecificParametersItem(ENABLE_LOGGING_HANDLER)) != null && enable_logging_handler.booleanValue()) {
            streamingService.setEnableLoggingHandler(true);
        }
        if ((autoReconnect = (Boolean)exchangeSpec.getExchangeSpecificParametersItem(AUTO_RECONNECT)) != null) {
            streamingService.setAutoReconnect(autoReconnect.booleanValue());
        }
    }
}

