/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.util;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyUtil.class);
    private Process proxyProcess;
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private String execLine;
    private long waitTimeMillis;

    public ProxyUtil(String execLine, long waitTimeMillis) {
        this.execLine = execLine;
        this.waitTimeMillis = waitTimeMillis;
    }

    public void startProxy() throws Exception {
        ScheduledFuture<Process> schedule = this.scheduler.schedule(() -> {
            Process p = null;
            try {
                p = Runtime.getRuntime().exec(this.execLine);
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return p;
        }, 1L, TimeUnit.SECONDS);
        Thread.sleep(this.waitTimeMillis);
        this.proxyProcess = (Process)schedule.get();
    }

    public void stopProxy() {
        this.proxyProcess.destroy();
    }

    public void shutdown() {
        if (this.proxyProcess.isAlive()) {
            this.proxyProcess.destroy();
        }
        this.scheduler.shutdown();
    }
}

