/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.gemini.dto;

import info.bitrich.xchangestream.gemini.dto.GeminiLimitOrder;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;

public class GeminiOrderbook {
    private final Map<BigDecimal, GeminiLimitOrder> asks;
    private final Map<BigDecimal, GeminiLimitOrder> bids = new TreeMap(Comparator.reverseOrder());
    private final CurrencyPair currencyPair;

    public GeminiOrderbook(CurrencyPair currencyPair) {
        this.asks = new TreeMap<BigDecimal, GeminiLimitOrder>();
        this.currencyPair = currencyPair;
    }

    public void createFromLevels(GeminiLimitOrder[] levels) {
        for (GeminiLimitOrder level : levels) {
            Map<BigDecimal, GeminiLimitOrder> orderBookSide = level.getSide() == Order.OrderType.ASK ? this.asks : this.bids;
            orderBookSide.put(level.getPrice(), level);
        }
    }

    public void updateLevel(GeminiLimitOrder level) {
        Map<BigDecimal, GeminiLimitOrder> orderBookSide = level.getSide() == Order.OrderType.ASK ? this.asks : this.bids;
        boolean shouldDelete = level.getAmount().compareTo(BigDecimal.ZERO) == 0;
        BigDecimal price = level.getPrice().stripTrailingZeros();
        if (shouldDelete) {
            orderBookSide.remove(price);
        } else {
            orderBookSide.put(price, level);
        }
    }

    public void updateLevels(GeminiLimitOrder[] levels) {
        for (GeminiLimitOrder level : levels) {
            this.updateLevel(level);
        }
    }

    public Collection<GeminiLimitOrder> getAsks() {
        return this.asks.values();
    }

    public Collection<GeminiLimitOrder> getBids() {
        return this.bids.values();
    }

    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }
}

