/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.gemini.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import info.bitrich.xchangestream.gemini.dto.GeminiLimitOrder;
import info.bitrich.xchangestream.gemini.dto.GeminiOrderbook;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.gemini.v1.dto.marketdata.GeminiTrade;

public class GeminiWebSocketTransaction {
    private String type;
    private String eventId;
    private String socket_sequence;
    private String timestamp;
    private String timestampms;
    private JsonNode events;

    public GeminiWebSocketTransaction(@JsonProperty(value="type") String type, @JsonProperty(value="eventId") String eventId, @JsonProperty(value="socket_sequence") String socket_sequence, @JsonProperty(value="timestamp") String timestamp, @JsonProperty(value="timestampms") String timestampms, @JsonProperty(value="events") JsonNode events) {
        this.type = type;
        this.eventId = eventId;
        this.socket_sequence = socket_sequence;
        this.timestamp = timestamp;
        this.timestampms = timestampms;
        this.events = events;
    }

    public String getType() {
        return this.type;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getSocket_sequence() {
        return this.socket_sequence;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getTimestampms() {
        return this.timestampms;
    }

    public JsonNode getEvents() {
        return this.events;
    }

    private static GeminiLimitOrder toGeminiLimitOrder(JsonNode jsonEvent) {
        BigDecimal price = new BigDecimal(jsonEvent.get("price").asText());
        BigDecimal amount = new BigDecimal(jsonEvent.get("remaining").asText());
        BigDecimal timestamp = new BigDecimal(new Date().getTime() / 1000L);
        Order.OrderType side = jsonEvent.get("side").asText().equals("ask") ? Order.OrderType.ASK : Order.OrderType.BID;
        return new GeminiLimitOrder(side, price, amount, timestamp);
    }

    public GeminiLimitOrder[] toGeminiLimitOrdersUpdate() {
        ArrayList<GeminiLimitOrder> levels = new ArrayList<GeminiLimitOrder>(1000);
        for (JsonNode jsonEvent : this.events) {
            if (!jsonEvent.has("reason") || !jsonEvent.get("reason").asText().equals("initial") && !jsonEvent.get("reason").asText().equals("place") && !jsonEvent.get("reason").asText().equals("cancel") && !jsonEvent.get("reason").asText().equals("trade")) continue;
            GeminiLimitOrder level = GeminiWebSocketTransaction.toGeminiLimitOrder(jsonEvent);
            levels.add(level);
        }
        return levels.toArray(new GeminiLimitOrder[levels.size()]);
    }

    public GeminiOrderbook toGeminiOrderbook(CurrencyPair currencyPair) {
        GeminiLimitOrder[] levels = this.toGeminiLimitOrdersUpdate();
        GeminiOrderbook orderbook = new GeminiOrderbook(currencyPair);
        orderbook.createFromLevels(levels);
        return orderbook;
    }

    private static GeminiTrade toGeminiTrade(JsonNode jsonEvent, long timestamp) {
        long tid = Long.valueOf(jsonEvent.get("tid").asText());
        BigDecimal price = new BigDecimal(jsonEvent.get("price").asText());
        BigDecimal amount = new BigDecimal(jsonEvent.get("amount").asText());
        String takerSide = jsonEvent.get("makerSide").asText().equals("ask") ? "buy" : "sell";
        return new GeminiTrade(price, amount, timestamp, "gemini", tid, takerSide);
    }

    public GeminiTrade[] toGeminiTrades() {
        long timestamp = Long.valueOf(this.timestamp);
        ArrayList<GeminiTrade> trades = new ArrayList<GeminiTrade>(1000);
        for (JsonNode jsonEvent : this.events) {
            if (!jsonEvent.get("type").asText().equals("trade")) continue;
            GeminiTrade trade = GeminiWebSocketTransaction.toGeminiTrade(jsonEvent, timestamp);
            trades.add(trade);
        }
        return trades.toArray(new GeminiTrade[trades.size()]);
    }
}

