/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.lgo;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import info.bitrich.xchangestream.lgo.LgoAdapter;
import info.bitrich.xchangestream.lgo.LgoStreamingService;
import info.bitrich.xchangestream.lgo.domain.LgoGroupedLevel2Update;
import info.bitrich.xchangestream.lgo.dto.LgoLevel2Update;
import info.bitrich.xchangestream.service.netty.StreamingObjectMapperHelper;
import io.reactivex.rxjava3.core.Observable;
import java.io.IOException;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LgoLevel2BatchSubscription {
    private final LgoStreamingService service;
    private final Observable<OrderBook> subscription;
    private static final Logger LOGGER = LoggerFactory.getLogger(LgoLevel2BatchSubscription.class);
    private CurrencyPair currencyPair;

    static LgoLevel2BatchSubscription create(LgoStreamingService service, CurrencyPair currencyPair) {
        return new LgoLevel2BatchSubscription(service, currencyPair);
    }

    private LgoLevel2BatchSubscription(LgoStreamingService service, CurrencyPair currencyPair) {
        this.service = service;
        this.currencyPair = currencyPair;
        this.subscription = this.createSubscription();
    }

    Observable<OrderBook> getSubscription() {
        return this.subscription;
    }

    private Observable<OrderBook> createSubscription() {
        ObjectMapper mapper = StreamingObjectMapperHelper.getObjectMapper();
        return this.service.subscribeChannel(LgoAdapter.channelName("level2", this.currencyPair), new Object[0]).map(s -> (LgoLevel2Update)mapper.treeToValue((TreeNode)s, LgoLevel2Update.class)).scan((Object)new LgoGroupedLevel2Update(), (acc, s) -> {
            if (s.getType().equals("snapshot")) {
                acc.applySnapshot(s.getBatchId(), this.currencyPair, s.getData());
                return acc;
            }
            if (acc.getLastBatchId() + 1L != s.getBatchId()) {
                LOGGER.warn("Wrong batch id. Expected {} got {}.", (Object)(acc.getLastBatchId() + 1L), (Object)s.getBatchId());
                acc.markDirty();
                this.resubscribe();
                return acc;
            }
            acc.applyUpdate(s.getBatchId(), this.currencyPair, s.getData());
            return acc;
        }).filter(LgoGroupedLevel2Update::isValid).map(LgoGroupedLevel2Update::orderBook).share();
    }

    private void resubscribe() {
        try {
            String channelName = LgoAdapter.channelName("level2", this.currencyPair);
            this.service.sendMessage(this.service.getUnsubscribeMessage(channelName, new Object[0]));
            this.service.sendMessage(this.service.getSubscribeMessage(channelName, new Object[0]));
        }
        catch (IOException e) {
            LOGGER.warn("Error resubscribing", (Throwable)e);
        }
    }
}

