/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.lgo;

import info.bitrich.xchangestream.core.ProductSubscription;
import info.bitrich.xchangestream.core.StreamingExchange;
import info.bitrich.xchangestream.core.StreamingMarketDataService;
import info.bitrich.xchangestream.lgo.LgoStreamingAccountService;
import info.bitrich.xchangestream.lgo.LgoStreamingMarketDataService;
import info.bitrich.xchangestream.lgo.LgoStreamingService;
import info.bitrich.xchangestream.lgo.LgoStreamingTradeService;
import info.bitrich.xchangestream.service.netty.ConnectionStateModel;
import info.bitrich.xchangestream.service.netty.NettyStreamingService;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Observable;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.lgo.LgoExchange;
import org.knowm.xchange.lgo.service.LgoKeyService;
import org.knowm.xchange.lgo.service.LgoSignatureService;
import si.mazi.rescu.SynchronizedValueFactory;

public class LgoStreamingExchange
extends LgoExchange
implements StreamingExchange {
    private LgoStreamingService streamingService;
    private LgoStreamingMarketDataService marketDataService;
    private LgoStreamingAccountService accountService;
    private LgoStreamingTradeService tradeService;

    protected void initServices() {
        super.initServices();
        this.streamingService = this.createStreamingService();
        this.marketDataService = new LgoStreamingMarketDataService(this.streamingService);
        this.accountService = new LgoStreamingAccountService(this.streamingService);
        this.tradeService = new LgoStreamingTradeService(this.streamingService, new LgoKeyService(this.getExchangeSpecification()), LgoSignatureService.createInstance((ExchangeSpecification)this.getExchangeSpecification()), (SynchronizedValueFactory<Long>)this.getNonceFactory());
    }

    private LgoStreamingService createStreamingService() {
        String apiUrl = this.getExchangeSpecification().getExchangeSpecificParameters().get("Websocket_Url").toString();
        LgoStreamingService streamingService = new LgoStreamingService(this.getSignatureService(), apiUrl);
        this.applyStreamingSpecification(this.getExchangeSpecification(), (NettyStreamingService)streamingService);
        return streamingService;
    }

    public void applySpecification(ExchangeSpecification exchangeSpecification) {
        super.applySpecification(exchangeSpecification);
        this.initServices();
    }

    public Completable connect(ProductSubscription ... args) {
        return this.streamingService.connect();
    }

    public Completable disconnect() {
        return this.streamingService.disconnect();
    }

    public boolean isAlive() {
        return this.streamingService.isSocketOpen();
    }

    public StreamingMarketDataService getStreamingMarketDataService() {
        return this.marketDataService;
    }

    public LgoStreamingAccountService getStreamingAccountService() {
        return this.accountService;
    }

    public LgoStreamingTradeService getStreamingTradeService() {
        return this.tradeService;
    }

    public Observable<ConnectionStateModel.State> connectionStateObservable() {
        return this.streamingService.subscribeConnectionState();
    }

    public void useCompressedMessages(boolean compressedMessages) {
    }
}

