/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.lgo;

import com.fasterxml.jackson.databind.JsonNode;
import info.bitrich.xchangestream.lgo.dto.LgoSubscription;
import info.bitrich.xchangestream.service.netty.JsonNettyStreamingService;
import info.bitrich.xchangestream.service.netty.StreamingObjectMapperHelper;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import java.io.IOException;
import java.time.Duration;
import org.knowm.xchange.lgo.service.LgoSignatureService;

public class LgoStreamingService
extends JsonNettyStreamingService {
    private final LgoSignatureService signatureService;
    private final String apiUrl;

    LgoStreamingService(LgoSignatureService signatureService, String apiUrl) {
        super(apiUrl, Integer.MAX_VALUE, Duration.ofSeconds(10L), Duration.ofSeconds(15L), 1);
        this.apiUrl = apiUrl;
        this.signatureService = signatureService;
    }

    protected String getChannelNameFromMessage(JsonNode message) {
        String channel = message.get("channel").asText();
        if (channel.equals("trades") || channel.equals("level2") || channel.equals("user")) {
            return channel + "-" + message.get("product_id").textValue();
        }
        return channel;
    }

    public String getSubscribeMessage(String channelName, Object ... args) throws IOException {
        return StreamingObjectMapperHelper.getObjectMapper().writeValueAsString((Object)LgoSubscription.subscribe(channelName));
    }

    public String getUnsubscribeMessage(String channelName, Object ... args) throws IOException {
        return StreamingObjectMapperHelper.getObjectMapper().writeValueAsString((Object)LgoSubscription.unsubscribe(channelName));
    }

    protected DefaultHttpHeaders getCustomHeaders() {
        DefaultHttpHeaders headers = super.getCustomHeaders();
        String timestamp = String.valueOf(System.currentTimeMillis());
        headers.add("X-LGO-DATE", (Object)timestamp);
        String auth = this.signatureService.digestSignedUrlHeader(this.apiUrl, timestamp);
        headers.add("Authorization", (Object)auth);
        return headers;
    }
}

