/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.lgo;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import info.bitrich.xchangestream.lgo.LgoAdapter;
import info.bitrich.xchangestream.lgo.LgoStreamingService;
import info.bitrich.xchangestream.lgo.domain.LgoGroupedTradeUpdate;
import info.bitrich.xchangestream.lgo.dto.LgoTradesUpdate;
import info.bitrich.xchangestream.service.netty.StreamingObjectMapperHelper;
import io.reactivex.rxjava3.core.Observable;
import java.io.IOException;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.Trade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LgoTradeBatchSubscription {
    private final LgoStreamingService service;
    private final CurrencyPair currencyPair;
    private final Observable<Trade> subscription;
    private static final Logger LOGGER = LoggerFactory.getLogger(LgoTradeBatchSubscription.class);

    static LgoTradeBatchSubscription create(LgoStreamingService service, CurrencyPair currencyPair) {
        return new LgoTradeBatchSubscription(service, currencyPair);
    }

    private LgoTradeBatchSubscription(LgoStreamingService service, CurrencyPair currencyPair) {
        this.service = service;
        this.currencyPair = currencyPair;
        this.subscription = this.createTradeSubscription();
    }

    private Observable<Trade> createTradeSubscription() {
        ObjectMapper mapper = StreamingObjectMapperHelper.getObjectMapper();
        Observable observable = this.service.subscribeChannel(LgoAdapter.channelName("trades", this.currencyPair), new Object[0]).map(s -> (LgoTradesUpdate)mapper.treeToValue((TreeNode)s, LgoTradesUpdate.class)).scan((Object)new LgoGroupedTradeUpdate(this.currencyPair), (acc, s) -> {
            if ("snapshot".equals(s.getType())) {
                acc.apply(s.getBatchId(), s.getTrades());
                return acc;
            }
            if (acc.getLastBatchId() + 1L != s.getBatchId()) {
                LOGGER.warn("Wrong batchId. Expected {} got {}.", (Object)(acc.getLastBatchId() + 1L), (Object)s.getBatchId());
                this.resubscribe();
            }
            acc.apply(s.getBatchId(), s.getTrades());
            return acc;
        }).skip(1L).flatMap(acc -> Observable.fromIterable(acc.getTrades()));
        return observable;
    }

    private void resubscribe() {
        String channelName = LgoAdapter.channelName("trades", this.currencyPair);
        try {
            this.service.sendMessage(this.service.getUnsubscribeMessage(channelName, new Object[0]));
            this.service.sendMessage(this.service.getSubscribeMessage(channelName, new Object[0]));
        }
        catch (IOException e) {
            LOGGER.error("Error resubscribing", (Throwable)e);
        }
    }

    Observable<Trade> getSubscription() {
        return this.subscription;
    }
}

