/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.lgo.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import info.bitrich.xchangestream.lgo.domain.LgoBatchOrderEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;

public class LgoDoneOrderEvent
extends LgoBatchOrderEvent {
    private final String reason;
    private final BigDecimal canceled;

    public LgoDoneOrderEvent(Long batchId, String type, String orderId, Date time, String reason, BigDecimal canceled) {
        super(batchId, type, orderId, time);
        this.reason = reason;
        this.canceled = canceled;
    }

    public LgoDoneOrderEvent(@JsonProperty(value="type") String type, @JsonProperty(value="order_id") String orderId, @JsonProperty(value="time") @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") Date time, @JsonProperty(value="reason") String reason, @JsonProperty(value="canceled") BigDecimal canceled) {
        super(type, orderId, time);
        this.reason = reason;
        this.canceled = canceled;
    }

    public String getReason() {
        return this.reason;
    }

    public BigDecimal getCanceled() {
        return this.canceled;
    }

    @Override
    public Order applyOnOrders(CurrencyPair currencyPair, Map<String, Order> allOrders) {
        Order doneOrder = allOrders.remove(this.getOrderId());
        if ("canceledBySelfTradePrevention".equals(this.reason) || "canceled".equals(this.reason)) {
            doneOrder.setOrderStatus(doneOrder.getStatus() == Order.OrderStatus.PARTIALLY_FILLED ? Order.OrderStatus.PARTIALLY_CANCELED : Order.OrderStatus.CANCELED);
        } else if ("filled".equals(this.reason)) {
            doneOrder.setOrderStatus(Order.OrderStatus.FILLED);
        } else {
            doneOrder.setOrderStatus(Order.OrderStatus.REJECTED);
        }
        return doneOrder;
    }
}

