/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.lgo.domain;

import info.bitrich.xchangestream.lgo.dto.LgoLevel2Data;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.OrderBookUpdate;
import org.knowm.xchange.instrument.Instrument;

public class LgoGroupedLevel2Update {
    private final OrderBook orderBook = new OrderBook(null, new ArrayList(), new ArrayList());
    private long lastBatchId;
    private boolean dirty = true;

    public void applySnapshot(long batchId, CurrencyPair currencyPair, LgoLevel2Data data) {
        this.dirty = false;
        this.applyUpdate(batchId, currencyPair, data);
    }

    public void applyUpdate(long batchId, CurrencyPair currencyPair, LgoLevel2Data data) {
        this.lastBatchId = batchId;
        this.updateL2Book(currencyPair, data);
    }

    private void updateL2Book(CurrencyPair currencyPair, LgoLevel2Data data) {
        Stream<OrderBookUpdate> asksUpdates = this.adaptLevel2Update(data, Order.OrderType.ASK, currencyPair);
        Stream<OrderBookUpdate> bidsUpdate = this.adaptLevel2Update(data, Order.OrderType.BID, currencyPair);
        asksUpdates.forEach(arg_0 -> ((OrderBook)this.orderBook).update(arg_0));
        bidsUpdate.forEach(arg_0 -> ((OrderBook)this.orderBook).update(arg_0));
    }

    private Stream<OrderBookUpdate> adaptLevel2Update(LgoLevel2Data data, Order.OrderType type, CurrencyPair currencyPair) {
        switch (type) {
            case BID: {
                return data.getBids().stream().map(value -> this.toBookUpdate(type, currencyPair, (List<String>)value));
            }
            case ASK: {
                return data.getAsks().stream().map(value -> this.toBookUpdate(type, currencyPair, (List<String>)value));
            }
        }
        return Stream.empty();
    }

    private OrderBookUpdate toBookUpdate(Order.OrderType type, CurrencyPair currencyPair, List<String> value) {
        BigDecimal price = new BigDecimal(value.get(0));
        BigDecimal quantity = new BigDecimal(value.get(1));
        return new OrderBookUpdate(type, null, (Instrument)currencyPair, price, null, quantity);
    }

    public void markDirty() {
        this.dirty = true;
    }

    public boolean isValid() {
        return !this.dirty;
    }

    public long getLastBatchId() {
        return this.lastBatchId;
    }

    public OrderBook orderBook() {
        return this.orderBook;
    }
}

