/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.lgo.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import info.bitrich.xchangestream.lgo.domain.LgoBatchOrderEvent;
import java.util.Date;
import java.util.Map;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;

public class LgoInvalidOrderEvent
extends LgoBatchOrderEvent {
    private final String reason;

    public LgoInvalidOrderEvent(Long batchId, String type, String orderId, Date time, String reason) {
        super(batchId, type, orderId, time);
        this.reason = reason;
    }

    public LgoInvalidOrderEvent(@JsonProperty(value="type") String type, @JsonProperty(value="order_id") String orderId, @JsonProperty(value="time") @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") Date time, @JsonProperty(value="reason") String reason) {
        super(type, orderId, time);
        this.reason = reason;
    }

    public String getReason() {
        return this.reason;
    }

    @Override
    public Order applyOnOrders(CurrencyPair currencyPair, Map<String, Order> allOrders) {
        Order doneOrder = allOrders.remove(this.getOrderId());
        doneOrder.setOrderStatus(Order.OrderStatus.REJECTED);
        return doneOrder;
    }
}

