/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.lgo.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import info.bitrich.xchangestream.lgo.domain.LgoBatchOrderEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;

public class LgoMatchOrderEvent
extends LgoBatchOrderEvent {
    private final String tradeId;
    private final BigDecimal tradePrice;
    private final BigDecimal filledQuantity;
    private final BigDecimal remainingQuantity;
    private final BigDecimal fees;
    private final String liquidity;
    private Order.OrderType orderType;

    public LgoMatchOrderEvent(@JsonProperty(value="type") String type, @JsonProperty(value="order_id") String orderId, @JsonProperty(value="time") @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") Date time, @JsonProperty(value="trade_id") String tradeId, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="filled_quantity") BigDecimal filledQuantity, @JsonProperty(value="remaining_quantity") BigDecimal remainingQuantity, @JsonProperty(value="fees") BigDecimal fees, @JsonProperty(value="liquidity") String liquidity) {
        super(type, orderId, time);
        this.tradeId = tradeId;
        this.tradePrice = price;
        this.filledQuantity = filledQuantity;
        this.remainingQuantity = remainingQuantity;
        this.fees = fees;
        this.liquidity = liquidity;
    }

    public LgoMatchOrderEvent(Long batchId, String type, String orderId, Date time, String tradeId, BigDecimal tradePrice, BigDecimal filledQuantity, BigDecimal remainingQuantity, BigDecimal fees, String liquidity, Order.OrderType orderType) {
        super(batchId, type, orderId, time);
        this.tradeId = tradeId;
        this.tradePrice = tradePrice;
        this.filledQuantity = filledQuantity;
        this.remainingQuantity = remainingQuantity;
        this.fees = fees;
        this.liquidity = liquidity;
        this.orderType = orderType;
    }

    public String getTradeId() {
        return this.tradeId;
    }

    public BigDecimal getTradePrice() {
        return this.tradePrice;
    }

    public BigDecimal getFilledQuantity() {
        return this.filledQuantity;
    }

    public BigDecimal getRemainingQuantity() {
        return this.remainingQuantity;
    }

    public BigDecimal getFees() {
        return this.fees;
    }

    public String getLiquidity() {
        return this.liquidity;
    }

    public Order.OrderType getOrderType() {
        return this.orderType;
    }

    public void setOrderType(Order.OrderType orderType) {
        this.orderType = orderType;
    }

    @Override
    public Order applyOnOrders(CurrencyPair currencyPair, Map<String, Order> allOrders) {
        Order matchedOrder = allOrders.get(this.getOrderId());
        matchedOrder.setOrderStatus(Order.OrderStatus.PARTIALLY_FILLED);
        matchedOrder.setCumulativeAmount(matchedOrder.getOriginalAmount().subtract(this.remainingQuantity));
        BigDecimal fee = matchedOrder.getFee() == null ? this.fees : matchedOrder.getFee().add(this.fees);
        matchedOrder.setFee(fee);
        return matchedOrder;
    }
}

