/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.lgo.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import info.bitrich.xchangestream.lgo.domain.LgoBatchOrderEvent;
import java.util.Date;
import java.util.Map;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;

public class LgoOpenOrderEvent
extends LgoBatchOrderEvent {
    public LgoOpenOrderEvent(Long batchId, String type, String orderId, Date time) {
        super(batchId, type, orderId, time);
    }

    public LgoOpenOrderEvent(@JsonProperty(value="type") String type, @JsonProperty(value="order_id") String orderId, @JsonProperty(value="time") @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") Date time) {
        super(type, orderId, time);
    }

    @Override
    public Order applyOnOrders(CurrencyPair currencyPair, Map<String, Order> allOrders) {
        Order pendingOrder = allOrders.get(this.getOrderId());
        Order.OrderStatus status = pendingOrder.getStatus().equals((Object)Order.OrderStatus.PARTIALLY_FILLED) ? pendingOrder.getStatus() : Order.OrderStatus.NEW;
        pendingOrder.setOrderStatus(status);
        return pendingOrder;
    }
}

