/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.lgo.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import info.bitrich.xchangestream.lgo.LgoAdapter;
import info.bitrich.xchangestream.lgo.domain.LgoBatchOrderEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;

public class LgoPendingOrderEvent
extends LgoBatchOrderEvent {
    private final String orderType;
    private final BigDecimal limitPrice;
    private final Order.OrderType side;
    private final BigDecimal initialAmount;

    public LgoPendingOrderEvent(@JsonProperty(value="type") String type, @JsonProperty(value="order_id") String orderId, @JsonProperty(value="time") @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") Date time, @JsonProperty(value="order_type") String orderType, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="side") String side, @JsonProperty(value="quantity") BigDecimal quantity) {
        super(type, orderId, time);
        this.orderType = orderType;
        this.limitPrice = price;
        this.side = side.equals("B") ? Order.OrderType.BID : Order.OrderType.ASK;
        this.initialAmount = quantity;
    }

    public LgoPendingOrderEvent(Long batchId, String type, String orderId, Date time, String orderType, BigDecimal limitPrice, Order.OrderType side, BigDecimal initialAmount) {
        super(batchId, type, orderId, time);
        this.orderType = orderType;
        this.limitPrice = limitPrice;
        this.side = side;
        this.initialAmount = initialAmount;
    }

    @Override
    public Order applyOnOrders(CurrencyPair currencyPair, Map<String, Order> allOrders) {
        Order order = LgoAdapter.adaptPendingOrder(this, currencyPair);
        allOrders.put(order.getId(), order);
        return order;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public BigDecimal getLimitPrice() {
        return this.limitPrice;
    }

    public Order.OrderType getSide() {
        return this.side;
    }

    public BigDecimal getInitialAmount() {
        return this.initialAmount;
    }
}

