/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.truefx.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import java.io.IOException;
import java.math.BigDecimal;

@JsonPropertyOrder(value={"pair", "timestamp", "bid", "bidBP", "ask", "askBP", "low", "high", "open"})
public class TrueFxTicker {
    private static final BigDecimal BASIS_POINT_MULTIPLIER = new BigDecimal("0.00001");
    private final String pair;
    private final long timestamp;
    private final BigDecimal bid;
    private final BigDecimal bidBP;
    private final BigDecimal ask;
    private final BigDecimal askBP;
    private final BigDecimal low;
    private final BigDecimal high;
    private final BigDecimal open;

    public TrueFxTicker(@JsonProperty(value="pair") String pair, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="bid") BigDecimal bid, @JsonProperty(value="bidBP") BigDecimal bidBP, @JsonProperty(value="ask") BigDecimal ask, @JsonProperty(value="askBP") BigDecimal askBP, @JsonProperty(value="low") BigDecimal low, @JsonProperty(value="high") BigDecimal high, @JsonProperty(value="open") BigDecimal open) {
        this.pair = pair;
        this.timestamp = timestamp;
        this.bid = bid;
        this.bidBP = bidBP;
        this.ask = ask;
        this.askBP = askBP;
        this.low = low;
        this.high = high;
        this.open = open;
    }

    public String getPair() {
        return this.pair;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public BigDecimal getBid() {
        return this.bid;
    }

    public BigDecimal getBidBP() {
        return this.bidBP;
    }

    public BigDecimal getAsk() {
        return this.ask;
    }

    public BigDecimal getAskBP() {
        return this.askBP;
    }

    public BigDecimal getLow() {
        return this.low;
    }

    public BigDecimal getHigh() {
        return this.high;
    }

    public BigDecimal getOpen() {
        return this.open;
    }

    public BigDecimal calcBid() {
        return this.bid.add(BASIS_POINT_MULTIPLIER.multiply(this.bidBP));
    }

    public BigDecimal calcAsk() {
        return this.ask.add(BASIS_POINT_MULTIPLIER.multiply(this.askBP));
    }

    public String toString() {
        return "TrueFxTicker [pair=" + this.pair + ", bid=" + this.calcBid() + ", ask=" + this.calcAsk() + ", low=" + this.low + ", high=" + this.high + "]";
    }

    public static class TrueFxTickerDeserializer
    extends JsonDeserializer<TrueFxTicker> {
        private final CsvMapper mapper = new CsvMapper();
        private final CsvSchema schema = this.mapper.schemaFor(TrueFxTicker.class);

        public TrueFxTicker deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
            ArrayNode array = (ArrayNode)this.mapper.readerFor(TrueFxTicker.class).with((FormatSchema)this.schema).readTree(parser);
            String pair = array.get(0).asText();
            long timestamp = array.get(1).asLong();
            BigDecimal bid = new BigDecimal(array.get(2).asText());
            BigDecimal bidBP = new BigDecimal(array.get(3).asText());
            BigDecimal ask = new BigDecimal(array.get(4).asText());
            BigDecimal askBP = new BigDecimal(array.get(5).asText());
            BigDecimal low = new BigDecimal(array.get(6).asText());
            BigDecimal high = new BigDecimal(array.get(7).asText());
            BigDecimal open = new BigDecimal(array.get(8).asText());
            return new TrueFxTicker(pair, timestamp, bid, bidBP, ask, askBP, low, high, open);
        }
    }
}

