/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.db.impl.data;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kodein.db.data.DataCursor;
import org.kodein.db.kv.KeyValueCursor;
import org.kodein.memory.io.Allocation;
import org.kodein.memory.io.AllocationJvmKt;
import org.kodein.memory.io.AllocationKt;
import org.kodein.memory.io.CursorWriteable;
import org.kodein.memory.io.Memory;
import org.kodein.memory.io.MemoryAllocation;
import org.kodein.memory.io.MemoryKt;
import org.kodein.memory.io.MemoryWriteable;
import org.kodein.memory.io.MemoryWriteableKt;
import org.kodein.memory.io.ReadAllocation;
import org.kodein.memory.io.ReadMemory;
import org.kodein.memory.io.ReadMemoryKt;
import org.kodein.memory.io.Writeable;
import org.kodein.memory.io.WriteableKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0012\b \u0018\u0000 &2\u00020\u0001:\u0001&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u0006\u0010\u0017\u001a\u00020\nJ\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\bH\u0002J\b\u0010\u001a\u001a\u00020\bH\u0004J\u0006\u0010\u001b\u001a\u00020\u0015J\u0006\u0010\u001c\u001a\u00020\u0015J\u000e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\bJ\u0006\u0010\u001f\u001a\u00020\u0015J\u0006\u0010 \u001a\u00020\u0015J\b\u0010!\u001a\u00020\bH$J\b\u0010\"\u001a\u00020\rH$J\u0006\u0010#\u001a\u00020\bJ\u0006\u0010$\u001a\u00020\bJ\u0006\u0010%\u001a\u00020\bR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006'"}, d2={"Lorg/kodein/db/impl/data/AbstractDataCursor;", "Lorg/kodein/db/data/DataCursor;", "cursor", "Lorg/kodein/db/kv/KeyValueCursor;", "prefix", "", "(Lorg/kodein/db/kv/KeyValueCursor;[B)V", "cachedItKey", "Lorg/kodein/memory/io/ReadMemory;", "cachedValid", "", "Ljava/lang/Boolean;", "cachedValue", "Lorg/kodein/memory/io/ReadAllocation;", "getCursor", "()Lorg/kodein/db/kv/KeyValueCursor;", "lastKey", "Lorg/kodein/memory/io/Allocation;", "getPrefix", "()[B", "cacheReset", "", "close", "isValid", "isValidSeekKey", "key", "itKey", "next", "prev", "seekTo", "target", "seekToFirst", "seekToLast", "thisKey", "thisValue", "transientKey", "transientSeekKey", "transientValue", "Companion", "kodein-db"})
public abstract class AbstractDataCursor
implements DataCursor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KeyValueCursor cursor;
    @NotNull
    private final byte[] prefix;
    @Nullable
    private Boolean cachedValid;
    @Nullable
    private ReadMemory cachedItKey;
    @Nullable
    private ReadAllocation cachedValue;
    @Nullable
    private Allocation lastKey;
    @NotNull
    private static final byte[] CORK;

    public AbstractDataCursor(@NotNull KeyValueCursor cursor, @NotNull byte[] prefix) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.cursor = cursor;
        this.prefix = prefix;
        this.seekToFirst();
    }

    @NotNull
    protected final KeyValueCursor getCursor() {
        return this.cursor;
    }

    @NotNull
    protected final byte[] getPrefix() {
        return this.prefix;
    }

    protected void cacheReset() {
        this.cachedValid = null;
        this.cachedItKey = null;
        ReadAllocation readAllocation = this.cachedValue;
        if (readAllocation != null) {
            readAllocation.close();
        }
        this.cachedValue = null;
    }

    @NotNull
    protected final ReadMemory itKey() {
        ReadMemory readMemory;
        ReadMemory readMemory2 = this.cachedItKey;
        if (readMemory2 == null) {
            ReadMemory readMemory3 = this.cursor.transientKey();
            boolean bl = false;
            boolean bl2 = false;
            ReadMemory it = readMemory3;
            boolean bl3 = false;
            this.cachedItKey = it;
            readMemory = readMemory3;
        } else {
            readMemory = readMemory2;
        }
        return readMemory;
    }

    public void close() {
        this.cachedValid = false;
        Allocation allocation = this.lastKey;
        if (allocation != null) {
            allocation.close();
        }
        this.cursor.close();
        this.cacheReset();
    }

    public final boolean isValid() {
        boolean bl;
        Boolean bl2 = this.cachedValid;
        if (bl2 == null) {
            boolean bl3 = this.cursor.isValid() && this.isValidSeekKey(this.itKey());
            boolean bl4 = false;
            boolean bl5 = false;
            boolean it = bl3;
            boolean bl6 = false;
            this.cachedValid = it;
            bl = bl3;
        } else {
            bl = bl2;
        }
        return bl;
    }

    public final void next() {
        this.cacheReset();
        this.cursor.next();
    }

    public final void prev() {
        this.cacheReset();
        this.cursor.prev();
    }

    private final boolean isValidSeekKey(ReadMemory key) {
        return ReadMemoryKt.startsWith((ReadMemory)key, (byte[])this.prefix);
    }

    public final void seekTo(@NotNull ReadMemory target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.cacheReset();
        boolean bl = this.isValidSeekKey(target);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Not a valid seek key";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.cursor.seekTo(target);
    }

    public final void seekToFirst() {
        this.cacheReset();
        this.cursor.seekTo((ReadMemory)MemoryKt.wrap((Memory.Companion)Memory.Companion, (byte[])this.prefix));
    }

    /*
     * WARNING - void declaration
     */
    public final void seekToLast() {
        this.cacheReset();
        if (this.lastKey == null) {
            MemoryAllocation memoryAllocation;
            void size$iv;
            byte[] prefix = this.prefix;
            Allocation.Companion companion = Allocation.Companion;
            int n = prefix.length + CORK.length;
            AbstractDataCursor abstractDataCursor = this;
            boolean $i$f$native = false;
            MemoryAllocation alloc$iv = AllocationJvmKt.native((Allocation.Companion)Allocation.Companion, (int)size$iv);
            try {
                Memory $this$write$iv$iv = (Memory)alloc$iv;
                boolean $i$f$write = false;
                MemoryWriteable w$iv$iv = MemoryWriteableKt.asWriteable((Memory)$this$write$iv$iv);
                CursorWriteable $this$native_u24lambda_u2d0$iv = (CursorWriteable)w$iv$iv;
                boolean bl = false;
                Writeable $this$seekToLast_u24lambda_u2d3 = (Writeable)$this$native_u24lambda_u2d0$iv;
                boolean bl2 = false;
                WriteableKt.writeBytes((Writeable)$this$seekToLast_u24lambda_u2d3, (byte[])prefix);
                WriteableKt.writeBytes((Writeable)$this$seekToLast_u24lambda_u2d3, (byte[])CORK);
                int length$iv = w$iv$iv.getPosition();
                memoryAllocation = size$iv == length$iv ? alloc$iv : AllocationKt.reduced((MemoryAllocation)alloc$iv, (int)length$iv);
            }
            catch (Throwable t$iv) {
                alloc$iv.close();
                throw t$iv;
            }
            MemoryAllocation memoryAllocation2 = memoryAllocation;
            abstractDataCursor.lastKey = (Allocation)memoryAllocation2;
        }
        Allocation allocation = this.lastKey;
        Intrinsics.checkNotNull((Object)allocation);
        this.cursor.seekTo((ReadMemory)allocation);
        while (this.cursor.isValid() && this.isValidSeekKey(this.cursor.transientKey())) {
            this.cursor.next();
        }
        if (this.cursor.isValid()) {
            this.cursor.prev();
        } else {
            this.cursor.seekToLast();
        }
    }

    @NotNull
    protected abstract ReadMemory thisKey();

    @NotNull
    public final ReadMemory transientKey() {
        boolean bl = this.isValid();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cursor is not valid";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return this.thisKey();
    }

    @NotNull
    protected abstract ReadAllocation thisValue();

    @NotNull
    public final ReadMemory transientValue() {
        boolean bl = this.isValid();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cursor is not valid";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ReadAllocation readAllocation = this.cachedValue;
        if (readAllocation != null) {
            ReadAllocation readAllocation2 = readAllocation;
            bl3 = false;
            boolean bl4 = false;
            ReadAllocation it = readAllocation2;
            boolean bl5 = false;
            return (ReadMemory)it;
        }
        readAllocation = this.thisValue();
        bl2 = false;
        bl3 = false;
        ReadAllocation it = readAllocation;
        boolean bl6 = false;
        this.cachedValue = it;
        return (ReadMemory)readAllocation;
    }

    @NotNull
    public final ReadMemory transientSeekKey() {
        boolean bl = this.isValid();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cursor is not valid";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return this.itKey();
    }

    static {
        int n = 0;
        byte[] byArray = new byte[16];
        while (n < 16) {
            int n2 = n++;
            byArray[n2] = -1;
        }
        CORK = byArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/kodein/db/impl/data/AbstractDataCursor$Companion;", "", "()V", "CORK", "", "kodein-db"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

