/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.db.impl.kv;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kodein.db.Options;
import org.kodein.db.impl.kv.LevelDBOptionsKt;
import org.kodein.db.kv.KeyValueBatch;
import org.kodein.db.leveldb.LevelDB;
import org.kodein.memory.io.ReadMemory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001H\u0016J\b\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J)\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J1\u0010\u0013\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0010\"\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J!\u0010\u0017\u001a\u00020\b2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0010\"\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/kodein/db/impl/kv/KeyValueBatchImpl;", "Lorg/kodein/db/kv/KeyValueBatch;", "levelDB", "Lorg/kodein/db/leveldb/LevelDB;", "writeBatch", "Lorg/kodein/db/leveldb/LevelDB$WriteBatch;", "(Lorg/kodein/db/leveldb/LevelDB;Lorg/kodein/db/leveldb/LevelDB$WriteBatch;)V", "append", "", "source", "clear", "close", "delete", "key", "Lorg/kodein/memory/io/ReadMemory;", "options", "", "Lorg/kodein/db/Options$BatchDelete;", "(Lorg/kodein/memory/io/ReadMemory;[Lorg/kodein/db/Options$BatchDelete;)V", "put", "value", "Lorg/kodein/db/Options$BatchPut;", "(Lorg/kodein/memory/io/ReadMemory;Lorg/kodein/memory/io/ReadMemory;[Lorg/kodein/db/Options$BatchPut;)V", "write", "Lorg/kodein/db/Options$BatchWrite;", "([Lorg/kodein/db/Options$BatchWrite;)V", "kodein-db"})
public final class KeyValueBatchImpl
implements KeyValueBatch {
    @NotNull
    private final LevelDB levelDB;
    @NotNull
    private final LevelDB.WriteBatch writeBatch;

    public KeyValueBatchImpl(@NotNull LevelDB levelDB, @NotNull LevelDB.WriteBatch writeBatch) {
        Intrinsics.checkNotNullParameter((Object)levelDB, (String)"levelDB");
        Intrinsics.checkNotNullParameter((Object)writeBatch, (String)"writeBatch");
        this.levelDB = levelDB;
        this.writeBatch = writeBatch;
    }

    public void put(@NotNull ReadMemory key, @NotNull ReadMemory value, Options.BatchPut ... options) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.writeBatch.put(key, value);
    }

    public void delete(@NotNull ReadMemory key, Options.BatchDelete ... options) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.writeBatch.delete(key);
    }

    public void clear() {
        this.writeBatch.clear();
    }

    public void append(@NotNull KeyValueBatch source) {
        LevelDB.WriteBatch writeBatch;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Object object = source instanceof KeyValueBatchImpl ? (KeyValueBatchImpl)source : null;
        LevelDB.WriteBatch writeBatch2 = writeBatch = object == null ? null : ((KeyValueBatchImpl)object).writeBatch;
        if (writeBatch == null) {
            object = "Source is not a KLevelWriteBatchImpl";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        this.writeBatch.append(writeBatch);
    }

    public void write(Options.BatchWrite ... options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.levelDB.write(this.writeBatch, LevelDBOptionsKt.from(LevelDB.WriteOptions.Companion, (Options[])options));
    }

    public void close() {
        this.writeBatch.close();
    }

    public void delete(@NotNull ReadMemory key) {
        KeyValueBatch.DefaultImpls.delete((KeyValueBatch)this, (ReadMemory)key);
    }

    public void delete(@NotNull ReadMemory key, Options.Deletes ... options) {
        KeyValueBatch.DefaultImpls.delete((KeyValueBatch)this, (ReadMemory)key, (Options.Deletes[])options);
    }

    public void put(@NotNull ReadMemory key, @NotNull ReadMemory value) {
        KeyValueBatch.DefaultImpls.put((KeyValueBatch)this, (ReadMemory)key, (ReadMemory)value);
    }

    public void put(@NotNull ReadMemory key, @NotNull ReadMemory value, Options.Puts ... options) {
        KeyValueBatch.DefaultImpls.put((KeyValueBatch)this, (ReadMemory)key, (ReadMemory)value, (Options.Puts[])options);
    }
}

