/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.db.impl.model.cache;

import java.io.Closeable;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kodein.db.Key;
import org.kodein.db.Options;
import org.kodein.db.Sized;
import org.kodein.db.impl.model.ResettableCursorModule;
import org.kodein.db.model.ModelCursor;
import org.kodein.db.model.cache.ModelCache;
import org.kodein.memory.io.ReadMemory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u00042\u00060\u0005j\u0002`\u0006B\u001b\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0011\u001a\u00020\u0012H\u0096\u0001J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0016J'\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018\"\u00020\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0012H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/kodein/db/impl/model/cache/CachedModelCursor;", "M", "", "Lorg/kodein/db/model/ModelCursor;", "Lorg/kodein/db/impl/model/ResettableCursorModule;", "Ljava/io/Closeable;", "Lorg/kodein/memory/Closeable;", "cursor", "cache", "Lorg/kodein/db/model/cache/ModelCache;", "(Lorg/kodein/db/model/ModelCursor;Lorg/kodein/db/model/cache/ModelCache;)V", "getCache", "()Lorg/kodein/db/model/cache/ModelCache;", "cachedEntry", "Lorg/kodein/db/model/cache/ModelCache$Entry$Cached;", "getCursor", "()Lorg/kodein/db/model/ModelCursor;", "close", "", "key", "Lorg/kodein/db/Key;", "model", "Lorg/kodein/db/Sized;", "options", "", "Lorg/kodein/db/Options$Get;", "([Lorg/kodein/db/Options$Get;)Lorg/kodein/db/Sized;", "reset", "kodein-db"})
public class CachedModelCursor<M>
implements ModelCursor<M>,
ResettableCursorModule,
Closeable {
    @NotNull
    private final ModelCursor<M> cursor;
    @NotNull
    private final ModelCache cache;
    @Nullable
    private ModelCache.Entry.Cached<M> cachedEntry;

    public CachedModelCursor(@NotNull ModelCursor<M> cursor, @NotNull ModelCache cache) {
        Intrinsics.checkNotNullParameter(cursor, (String)"cursor");
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this.cursor = cursor;
        this.cache = cache;
    }

    @NotNull
    public ModelCursor<M> getCursor() {
        return this.cursor;
    }

    @NotNull
    public final ModelCache getCache() {
        return this.cache;
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    @Override
    public void reset() {
        this.cachedEntry = null;
    }

    @NotNull
    public Key<M> key() {
        return this.getCursor().key();
    }

    @NotNull
    public Sized<M> model(Options.Get ... options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (this.cachedEntry == null) {
            this.cachedEntry = (ModelCache.Entry.Cached)this.cache.getOrRetrieveEntry(this.key(), new Function0<Sized<? extends M>>(this, options){
                final /* synthetic */ CachedModelCursor<M> this$0;
                final /* synthetic */ Options.Get[] $options;
                {
                    this.this$0 = $receiver;
                    this.$options = $options;
                    super(0);
                }

                @Nullable
                public final Sized<M> invoke() {
                    return this.this$0.getCursor().model(Arrays.copyOf(this.$options, this.$options.length));
                }
            });
        }
        ModelCache.Entry.Cached<M> cached = this.cachedEntry;
        Intrinsics.checkNotNull(cached);
        return (Sized)cached;
    }

    @Override
    public boolean isValid() {
        return ResettableCursorModule.DefaultImpls.isValid(this);
    }

    @Override
    public void next() {
        ResettableCursorModule.DefaultImpls.next(this);
    }

    @Override
    public void prev() {
        ResettableCursorModule.DefaultImpls.prev(this);
    }

    @Override
    public void seekTo(@NotNull ReadMemory target) {
        ResettableCursorModule.DefaultImpls.seekTo(this, target);
    }

    @Override
    public void seekToFirst() {
        ResettableCursorModule.DefaultImpls.seekToFirst(this);
    }

    @Override
    public void seekToLast() {
        ResettableCursorModule.DefaultImpls.seekToLast(this);
    }

    @Override
    @NotNull
    public ReadMemory transientSeekKey() {
        return ResettableCursorModule.DefaultImpls.transientSeekKey(this);
    }
}

