/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;
import org.kohsuke.github.HttpException;
import org.kohsuke.github.connector.GitHubConnectorResponse;

abstract class GitHubConnectorResponseErrorHandler {
    static GitHubConnectorResponseErrorHandler STATUS_HTTP_BAD_REQUEST_OR_GREATER = new GitHubConnectorResponseErrorHandler(){

        @Override
        public boolean isError(@NotNull GitHubConnectorResponse connectorResponse) throws IOException {
            return connectorResponse.statusCode() >= 400;
        }

        @Override
        public void onError(@NotNull GitHubConnectorResponse connectorResponse) throws IOException {
            if (connectorResponse.statusCode() == 404) {
                throw new FileNotFoundException(connectorResponse.request().url().toString());
            }
            throw new HttpException(connectorResponse);
        }
    };

    GitHubConnectorResponseErrorHandler() {
    }

    abstract boolean isError(@Nonnull GitHubConnectorResponse var1) throws IOException;

    public abstract void onError(@Nonnull GitHubConnectorResponse var1) throws IOException;
}

