/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URL;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHCommitComment;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHCommitStatus;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHHook;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueBuilder;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHMilestone;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHPerson;
import org.kohsuke.github.GHPersonSet;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.Requester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class GHRepository {
    GitHub root;
    private String description;
    private String homepage;
    private String name;
    private String url;
    private String html_url;
    private GHUser owner;
    private boolean has_issues;
    private boolean has_wiki;
    private boolean fork;
    private boolean _private;
    private boolean has_downloads;
    private int watchers;
    private int forks;
    private int open_issues;
    private int size;
    private String created_at;
    private String pushed_at;
    private Map<Integer, GHMilestone> milestones = new HashMap<Integer, GHMilestone>();
    private String master_branch;
    private String language;
    private Map<String, GHCommit> commits = new HashMap<String, GHCommit>();
    private GHRepoPermission permissions;
    private final Set<URL> postCommitHooks = new AbstractSet<URL>(){

        private List<URL> getPostCommitHooks() {
            try {
                ArrayList<URL> r = new ArrayList<URL>();
                for (GHHook h : GHRepository.this.getHooks()) {
                    if (!h.getName().equals("web")) continue;
                    r.add(new URL(h.getConfig().get("url")));
                }
                return r;
            }
            catch (IOException e) {
                throw new GHException("Failed to retrieve post-commit hooks", e);
            }
        }

        @Override
        public Iterator<URL> iterator() {
            return this.getPostCommitHooks().iterator();
        }

        @Override
        public int size() {
            return this.getPostCommitHooks().size();
        }

        @Override
        public boolean add(URL url) {
            try {
                GHRepository.this.createWebHook(url);
                return true;
            }
            catch (IOException e) {
                throw new GHException("Failed to update post-commit hooks", e);
            }
        }

        @Override
        public boolean remove(Object url) {
            try {
                String _url = ((URL)url).toExternalForm();
                for (GHHook h : GHRepository.this.getHooks()) {
                    if (!h.getName().equals("web") || !h.getConfig().get("url").equals(_url)) continue;
                    h.delete();
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                throw new GHException("Failed to update post-commit hooks", e);
            }
        }
    };

    public String getDescription() {
        return this.description;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public String getUrl() {
        return this.html_url;
    }

    public String getGitTransportUrl() {
        return "git://github.com/" + this.getOwnerName() + "/" + this.name + ".git";
    }

    public String gitHttpTransportUrl() {
        return "https://github.com/" + this.getOwnerName() + "/" + this.name + ".git";
    }

    public String getName() {
        return this.name;
    }

    public boolean hasPullAccess() {
        return this.permissions != null && this.permissions.pull;
    }

    public boolean hasPushAccess() {
        return this.permissions != null && this.permissions.push;
    }

    public boolean hasAdminAccess() {
        return this.permissions != null && this.permissions.admin;
    }

    public String getLanguage() {
        return this.language;
    }

    public GHUser getOwner() throws IOException {
        return this.root.getUser(this.owner.login);
    }

    public GHIssue getIssue(int id) throws IOException {
        return ((GHIssue)((Object)this.root.retrieve().to("/repos/" + this.owner.login + "/" + this.name + "/issues/" + id, GHIssue.class))).wrap(this);
    }

    public GHIssueBuilder createIssue(String title) {
        return new GHIssueBuilder(this, title);
    }

    public List<GHIssue> getIssues(GHIssueState state) throws IOException {
        return Arrays.asList(GHIssue.wrap((GHIssue[])this.root.retrieve().to("/repos/" + this.owner.login + "/" + this.name + "/issues?state=" + state.toString().toLowerCase(), GHIssue[].class), this));
    }

    protected String getOwnerName() {
        return this.owner.login;
    }

    public boolean hasIssues() {
        return this.has_issues;
    }

    public boolean hasWiki() {
        return this.has_wiki;
    }

    public boolean isFork() {
        return this.fork;
    }

    public int getForks() {
        return this.forks;
    }

    public boolean isPrivate() {
        return this._private;
    }

    public boolean hasDownloads() {
        return this.has_downloads;
    }

    public int getWatchers() {
        return this.watchers;
    }

    public int getOpenIssueCount() {
        return this.open_issues;
    }

    public Date getPushedAt() {
        return GitHub.parseDate(this.pushed_at);
    }

    public Date getCreatedAt() {
        return GitHub.parseDate(this.created_at);
    }

    public String getMasterBranch() {
        return this.master_branch;
    }

    public int getSize() {
        return this.size;
    }

    @WithBridgeMethods(value={Set.class})
    public GHPersonSet<GHUser> getCollaborators() throws IOException {
        return new GHPersonSet((GHPerson[])GHUser.wrap((GHUser[])this.root.retrieve().to("/repos/" + this.owner.login + "/" + this.name + "/collaborators", GHUser[].class), this.root));
    }

    public Set<String> getCollaboratorNames() throws IOException {
        HashSet<String> r = new HashSet<String>();
        for (GHUser u : GHUser.wrap((GHUser[])this.root.retrieve().to("/repos/" + this.owner.login + "/" + this.name + "/collaborators", GHUser[].class), this.root)) {
            r.add(u.login);
        }
        return r;
    }

    public Set<GHTeam> getTeams() throws IOException {
        return Collections.unmodifiableSet(new HashSet<GHTeam>(Arrays.asList(GHTeam.wrapUp((GHTeam[])this.root.retrieve().to("/repos/" + this.owner.login + "/" + this.name + "/teams", GHTeam[].class), this.root.getOrganization(this.owner.login)))));
    }

    public void addCollaborators(GHUser ... users) throws IOException {
        this.addCollaborators(Arrays.asList(users));
    }

    public void addCollaborators(Collection<GHUser> users) throws IOException {
        this.modifyCollaborators(users, "PUT");
    }

    public void removeCollaborators(GHUser ... users) throws IOException {
        this.removeCollaborators(Arrays.asList(users));
    }

    public void removeCollaborators(Collection<GHUser> users) throws IOException {
        this.modifyCollaborators(users, "DELETE");
    }

    private void modifyCollaborators(Collection<GHUser> users, String method) throws IOException {
        this.verifyMine();
        for (GHUser user : users) {
            new Requester(this.root).method(method).to("/repos/" + this.owner.login + "/" + this.name + "/collaborators/" + user.getLogin());
        }
    }

    public void setEmailServiceHook(String address) throws IOException {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("address", address);
        new Requester(this.root).method("POST").with("name", "email").with("config", config).with("active", "true").to(String.format("/repos/%s/%s/hooks", this.owner.login, this.name));
    }

    private void edit(String key, String value) throws IOException {
        Requester requester = new Requester(this.root);
        if (!key.equals("name")) {
            requester.with("name", this.name);
        }
        requester.with(key, value).method("PATCH").to("/repos/" + this.owner.login + "/" + this.name);
    }

    public void enableIssueTracker(boolean v) throws IOException {
        this.edit("has_issues", String.valueOf(v));
    }

    public void enableWiki(boolean v) throws IOException {
        this.edit("has_wiki", String.valueOf(v));
    }

    public void enableDownloads(boolean v) throws IOException {
        this.edit("has_downloads", String.valueOf(v));
    }

    public void renameTo(String name) throws IOException {
        this.edit("name", name);
    }

    public void setDescription(String value) throws IOException {
        this.edit("description", value);
    }

    public void setHomepage(String value) throws IOException {
        this.edit("homepage", value);
    }

    public void delete() throws IOException {
        new Requester(this.root).method("DELETE").to("/repos/" + this.owner.login + "/" + this.name);
    }

    public GHRepository fork() throws IOException {
        return ((GHRepository)((Object)new Requester(this.root).method("POST").to("/repos/" + this.owner.login + "/" + this.name + "/forks", GHRepository.class))).wrap(this.root);
    }

    public GHRepository forkTo(GHOrganization org) throws IOException {
        new Requester(this.root).to(String.format("/repos/%s/%s/forks?org=%s", this.owner.login, this.name, org.getLogin()));
        for (int i = 0; i < 10; ++i) {
            GHRepository r = org.getRepository(this.name);
            if (r != null) {
                return r;
            }
            try {
                Thread.sleep(3000L);
                continue;
            }
            catch (InterruptedException e) {
                throw (IOException)new InterruptedIOException().initCause(e);
            }
        }
        throw new IOException(this + " was forked into " + org.getLogin() + " but can't find the new repository");
    }

    public GHPullRequest getPullRequest(int i) throws IOException {
        return ((GHPullRequest)((Object)this.root.retrieve().to("/repos/" + this.owner.login + '/' + this.name + "/pulls/" + i, GHPullRequest.class))).wrapUp(this);
    }

    public List<GHPullRequest> getPullRequests(GHIssueState state) throws IOException {
        return this.listPullRequests(state).asList();
    }

    public PagedIterable<GHPullRequest> listPullRequests(final GHIssueState state) {
        return new PagedIterable<GHPullRequest>(){

            @Override
            public PagedIterator<GHPullRequest> iterator() {
                return new PagedIterator<GHPullRequest>(GHRepository.this.root.retrieve().asIterator(String.format("/repos/%s/%s/pulls?state=%s", ((GHRepository)GHRepository.this).owner.login, GHRepository.this.name, state.name().toLowerCase(Locale.ENGLISH)), GHPullRequest[].class)){

                    protected void wrapUp(GHPullRequest[] page) {
                        for (GHPullRequest pr : page) {
                            pr.wrap(GHRepository.this);
                        }
                    }
                };
            }
        };
    }

    public List<GHHook> getHooks() throws IOException {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList((Object[])this.root.retrieve().to(String.format("/repos/%s/%s/hooks", this.owner.login, this.name), GHHook[].class)));
        for (GHHook gHHook : list) {
            gHHook.wrap(this);
        }
        return list;
    }

    public GHHook getHook(int id) throws IOException {
        return ((GHHook)((Object)this.root.retrieve().to(String.format("/repos/%s/%s/hooks/%d", this.owner.login, this.name, id), GHHook.class))).wrap(this);
    }

    public GHCommit getCommit(String sha1) throws IOException {
        GHCommit c = this.commits.get(sha1);
        if (c == null) {
            c = ((GHCommit)((Object)this.root.retrieve().to(String.format("/repos/%s/%s/commits/%s", this.owner.login, this.name, sha1), GHCommit.class))).wrapUp(this);
            this.commits.put(sha1, c);
        }
        return c;
    }

    public PagedIterable<GHCommit> listCommits() {
        return new PagedIterable<GHCommit>(){

            @Override
            public PagedIterator<GHCommit> iterator() {
                return new PagedIterator<GHCommit>(GHRepository.this.root.retrieve().asIterator(String.format("/repos/%s/%s/commits", ((GHRepository)GHRepository.this).owner.login, GHRepository.this.name), GHCommit[].class)){

                    protected void wrapUp(GHCommit[] page) {
                        for (GHCommit c : page) {
                            c.wrapUp(GHRepository.this);
                        }
                    }
                };
            }
        };
    }

    public PagedIterable<GHCommitComment> listCommitComments() {
        return new PagedIterable<GHCommitComment>(){

            @Override
            public PagedIterator<GHCommitComment> iterator() {
                return new PagedIterator<GHCommitComment>(GHRepository.this.root.retrieve().asIterator(String.format("/repos/%s/%s/comments", ((GHRepository)GHRepository.this).owner.login, GHRepository.this.name), GHCommitComment[].class)){

                    protected void wrapUp(GHCommitComment[] page) {
                        for (GHCommitComment c : page) {
                            c.wrap(GHRepository.this);
                        }
                    }
                };
            }
        };
    }

    public PagedIterable<GHCommitStatus> listCommitStatuses(final String sha1) throws IOException {
        return new PagedIterable<GHCommitStatus>(){

            @Override
            public PagedIterator<GHCommitStatus> iterator() {
                return new PagedIterator<GHCommitStatus>(GHRepository.this.root.retrieve().asIterator(String.format("/repos/%s/%s/statuses/%s", ((GHRepository)GHRepository.this).owner.login, GHRepository.this.name, sha1), GHCommitStatus[].class)){

                    protected void wrapUp(GHCommitStatus[] page) {
                        for (GHCommitStatus c : page) {
                            c.wrapUp(GHRepository.this.root);
                        }
                    }
                };
            }
        };
    }

    public GHCommitStatus getLastCommitStatus(String sha1) throws IOException {
        List<GHCommitStatus> v = this.listCommitStatuses(sha1).asList();
        return v.isEmpty() ? null : v.get(0);
    }

    public GHCommitStatus createCommitStatus(String sha1, GHCommitState state, String targetUrl, String description) throws IOException {
        return ((GHCommitStatus)((Object)new Requester(this.root).with("state", state.name().toLowerCase(Locale.ENGLISH)).with("target_url", targetUrl).with("description", description).to(String.format("/repos/%s/%s/statuses/%s", this.owner.login, this.name, sha1), GHCommitStatus.class))).wrapUp(this.root);
    }

    public GHHook createHook(String name, Map<String, String> config, Collection<GHEvent> events, boolean active) throws IOException {
        ArrayList<String> ea = null;
        if (events != null) {
            ea = new ArrayList<String>();
            for (GHEvent e : events) {
                ea.add(e.name().toLowerCase(Locale.ENGLISH));
            }
        }
        return ((GHHook)((Object)new Requester(this.root).with("name", name).with("active", active)._with("config", config)._with("events", ea).to(String.format("/repos/%s/%s/hooks", this.owner.login, this.name), GHHook.class))).wrap(this);
    }

    public GHHook createWebHook(URL url, Collection<GHEvent> events) throws IOException {
        return this.createHook("web", Collections.singletonMap("url", url.toExternalForm()), events, true);
    }

    public GHHook createWebHook(URL url) throws IOException {
        return this.createWebHook(url, null);
    }

    private void verifyMine() throws IOException {
        if (!this.root.login.equals(this.owner.login)) {
            throw new IOException("Operation not applicable to a repository owned by someone else: " + this.owner.login);
        }
    }

    public Set<URL> getPostCommitHooks() {
        return this.postCommitHooks;
    }

    GHRepository wrap(GitHub root) {
        this.root = root;
        return this;
    }

    public Map<String, GHBranch> getBranches() throws IOException {
        TreeMap<String, GHBranch> r = new TreeMap<String, GHBranch>();
        for (GHBranch p : (GHBranch[])this.root.retrieve().to(this.getApiTailUrl("branches"), GHBranch[].class)) {
            p.wrap(this);
            r.put(p.getName(), p);
        }
        return r;
    }

    public Map<Integer, GHMilestone> getMilestones() throws IOException {
        TreeMap<Integer, GHMilestone> milestones = new TreeMap<Integer, GHMilestone>();
        for (GHMilestone m : this.listMilestones(GHIssueState.OPEN)) {
            milestones.put(m.getNumber(), m);
        }
        return milestones;
    }

    public PagedIterable<GHMilestone> listMilestones(final GHIssueState state) {
        return new PagedIterable<GHMilestone>(){

            @Override
            public PagedIterator<GHMilestone> iterator() {
                return new PagedIterator<GHMilestone>(GHRepository.this.root.retrieve().asIterator(GHRepository.this.getApiTailUrl("milestones?state=" + state.toString().toLowerCase(Locale.ENGLISH)), GHMilestone[].class)){

                    protected void wrapUp(GHMilestone[] page) {
                        for (GHMilestone c : page) {
                            c.wrap(GHRepository.this);
                        }
                    }
                };
            }
        };
    }

    public GHMilestone getMilestone(int number) throws IOException {
        GHMilestone m = this.milestones.get(number);
        if (m == null) {
            m = (GHMilestone)((Object)this.root.retrieve().to(this.getApiTailUrl("milestones/" + number), GHMilestone.class));
            m.owner = this;
            m.root = this.root;
            this.milestones.put(m.getNumber(), m);
        }
        return m;
    }

    public GHMilestone createMilestone(String title, String description) throws IOException {
        return ((GHMilestone)((Object)new Requester(this.root).with("title", title).with("description", description).method("POST").to(this.getApiTailUrl("milestones"), GHMilestone.class))).wrap(this);
    }

    public String toString() {
        return "Repository:" + this.owner.login + ":" + this.name;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GHRepository) {
            GHRepository that = (GHRepository)obj;
            return this.owner.login.equals(that.owner.login) && this.name.equals(that.name);
        }
        return false;
    }

    String getApiTailUrl(String tail) {
        return "/repos/" + this.owner.login + "/" + this.name + '/' + tail;
    }

    private static class GHRepoPermission {
        boolean pull;
        boolean push;
        boolean admin;

        private GHRepoPermission() {
        }
    }
}

