/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.codegen;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.komapper.codegen.ClassNameResolver;
import org.komapper.codegen.StringUtil;
import org.komapper.codegen.Table;

class ClassNameResolverImpl
implements ClassNameResolver {
    private final String prefix;
    private final String suffix;

    ClassNameResolverImpl(@NotNull String prefix, @NotNull String suffix) {
        this.prefix = Objects.requireNonNull(prefix);
        this.suffix = Objects.requireNonNull(suffix);
    }

    @Override
    @NotNull
    public String resolve(@NotNull Table table) {
        return this.prefix + StringUtil.snakeToUpperCamelCase(table.getName()) + this.suffix;
    }
}

