/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.codegen;

import io.github.encryptorcode.pluralize.Pluralize;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.komapper.codegen.ClassNameResolver;
import org.komapper.codegen.StringUtil;
import org.komapper.codegen.Table;

class SingularClassNameResolver
implements ClassNameResolver {
    private final String prefix;
    private final String suffix;

    SingularClassNameResolver(@NotNull String prefix, @NotNull String suffix) {
        this.prefix = Objects.requireNonNull(prefix);
        this.suffix = Objects.requireNonNull(suffix);
    }

    @Override
    @NotNull
    public String resolve(@NotNull Table table) {
        String[] words = table.getName().split("_");
        String singularTableName = Arrays.stream(words).map(Pluralize::singular).collect(Collectors.joining("_"));
        return this.prefix + StringUtil.snakeToUpperCamelCase(singularTableName) + this.suffix;
    }
}

