/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.datetime.jdbc;

import java.time.LocalDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.komapper.datetime.jdbc.JdbcKotlinInstantType;
import org.komapper.datetime.jdbc.JdbcKotlinLocalDateTimeType;
import org.komapper.datetime.jdbc.JdbcKotlinLocalDateType;
import org.komapper.jdbc.JdbcDataType;
import org.komapper.jdbc.JdbcDataTypeProvider;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\u0007\u001a\n\u0012\u0004\u0012\u0002H\t\u0018\u00010\b\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/komapper/datetime/jdbc/JdbcDatetimeTypeProvider;", "Lorg/komapper/jdbc/JdbcDataTypeProvider;", "next", "<init>", "(Lorg/komapper/jdbc/JdbcDataTypeProvider;)V", "getNext", "()Lorg/komapper/jdbc/JdbcDataTypeProvider;", "get", "Lorg/komapper/jdbc/JdbcDataType;", "T", "", "type", "Lkotlin/reflect/KType;", "komapper-datetime-jdbc"})
public final class JdbcDatetimeTypeProvider
implements JdbcDataTypeProvider {
    @NotNull
    private final JdbcDataTypeProvider next;

    public JdbcDatetimeTypeProvider(@NotNull JdbcDataTypeProvider next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        this.next = next;
    }

    @NotNull
    public final JdbcDataTypeProvider getNext() {
        return this.next;
    }

    @Nullable
    public <T> JdbcDataType<T> get(@NotNull KType type) {
        JdbcDataType jdbcDataType;
        JdbcDataType dataType;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        KClassifier kClassifier = type.getClassifier();
        if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Instant.class))) {
            JdbcDataType jdbcDataType2 = this.next.get(Reflection.typeOf(java.time.Instant.class));
            if (jdbcDataType2 == null) {
                throw new IllegalStateException("The dataType is not found for java.time.Instant.".toString());
            }
            dataType = jdbcDataType2;
            jdbcDataType = (JdbcDataType)new JdbcKotlinInstantType((JdbcDataType<java.time.Instant>)dataType);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(LocalDate.class))) {
            JdbcDataType jdbcDataType3 = this.next.get(Reflection.typeOf(java.time.LocalDate.class));
            if (jdbcDataType3 == null) {
                throw new IllegalStateException("The dataType is not found for java.time.LocalDate.".toString());
            }
            dataType = jdbcDataType3;
            jdbcDataType = (JdbcDataType)new JdbcKotlinLocalDateType((JdbcDataType<java.time.LocalDate>)dataType);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(kotlinx.datetime.LocalDateTime.class))) {
            JdbcDataType jdbcDataType4 = this.next.get(Reflection.typeOf(LocalDateTime.class));
            if (jdbcDataType4 == null) {
                throw new IllegalStateException("The dataType is not found for java.time.LocalDateTime.".toString());
            }
            dataType = jdbcDataType4;
            jdbcDataType = (JdbcDataType)new JdbcKotlinLocalDateTimeType((JdbcDataType<LocalDateTime>)dataType);
        } else {
            jdbcDataType = this.next.get(type);
        }
        JdbcDataType dataType2 = jdbcDataType;
        return dataType2;
    }
}

