/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.jdbc;

import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.komapper.core.ClockProvider;
import org.komapper.core.DefaultClockProvider;
import org.komapper.core.DefaultLoggerFacade;
import org.komapper.core.Dialect;
import org.komapper.core.ExecutionOptions;
import org.komapper.core.Logger;
import org.komapper.core.LoggerFacade;
import org.komapper.core.StatementInspector;
import org.komapper.core.TemplateStatementBuilder;
import org.komapper.core.TemplateStatementBuilders;
import org.komapper.jdbc.DefaultJdbcDataFactory;
import org.komapper.jdbc.DefaultJdbcDatabaseConfig;
import org.komapper.jdbc.JdbcDataFactory;
import org.komapper.jdbc.JdbcDataType;
import org.komapper.jdbc.JdbcDatabaseConfig;
import org.komapper.jdbc.JdbcDialect;
import org.komapper.jdbc.JdbcDialects;
import org.komapper.jdbc.JdbcSession;
import org.komapper.jdbc.JdbcSessions;
import org.komapper.jdbc.SimpleDataSource;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B7\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\u0012\b\u0002\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u00a2\u0006\u0002\u0010\tB\u0015\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0013\u001a\u00020\u00148VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001b\u0010#\u001a\u00020$8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u0018\u001a\u0004\b%\u0010&R\u001b\u0010(\u001a\u00020)8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u0018\u001a\u0004\b*\u0010+R\u001b\u0010-\u001a\u00020.8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\u0018\u001a\u0004\b/\u00100R\u001b\u00102\u001a\u0002038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u0010\u0018\u001a\u0004\b4\u00105R\u001b\u00107\u001a\u0002088VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u0010\u0018\u001a\u0004\b9\u0010:\u00a8\u0006<"}, d2={"Lorg/komapper/jdbc/DefaultJdbcDatabaseConfig;", "Lorg/komapper/jdbc/JdbcDatabaseConfig;", "url", "", "user", "password", "dataTypes", "", "Lorg/komapper/jdbc/JdbcDataType;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "dataSource", "Ljavax/sql/DataSource;", "dialect", "Lorg/komapper/jdbc/JdbcDialect;", "(Ljavax/sql/DataSource;Lorg/komapper/jdbc/JdbcDialect;)V", "clockProvider", "Lorg/komapper/core/ClockProvider;", "getClockProvider", "()Lorg/komapper/core/ClockProvider;", "dataFactory", "Lorg/komapper/jdbc/JdbcDataFactory;", "getDataFactory", "()Lorg/komapper/jdbc/JdbcDataFactory;", "dataFactory$delegate", "Lkotlin/Lazy;", "getDialect", "()Lorg/komapper/jdbc/JdbcDialect;", "executionOptions", "Lorg/komapper/core/ExecutionOptions;", "getExecutionOptions", "()Lorg/komapper/core/ExecutionOptions;", "id", "Ljava/util/UUID;", "getId", "()Ljava/util/UUID;", "logger", "Lorg/komapper/core/Logger;", "getLogger", "()Lorg/komapper/core/Logger;", "logger$delegate", "loggerFacade", "Lorg/komapper/core/LoggerFacade;", "getLoggerFacade", "()Lorg/komapper/core/LoggerFacade;", "loggerFacade$delegate", "session", "Lorg/komapper/jdbc/JdbcSession;", "getSession", "()Lorg/komapper/jdbc/JdbcSession;", "session$delegate", "statementInspector", "Lorg/komapper/core/StatementInspector;", "getStatementInspector", "()Lorg/komapper/core/StatementInspector;", "statementInspector$delegate", "templateStatementBuilder", "Lorg/komapper/core/TemplateStatementBuilder;", "getTemplateStatementBuilder", "()Lorg/komapper/core/TemplateStatementBuilder;", "templateStatementBuilder$delegate", "komapper-jdbc"})
public class DefaultJdbcDatabaseConfig
implements JdbcDatabaseConfig {
    @NotNull
    private final JdbcDialect dialect;
    @NotNull
    private final UUID id;
    @NotNull
    private final ClockProvider clockProvider;
    @NotNull
    private final ExecutionOptions executionOptions;
    @NotNull
    private final Lazy logger$delegate;
    @NotNull
    private final Lazy loggerFacade$delegate;
    @NotNull
    private final Lazy session$delegate;
    @NotNull
    private final Lazy statementInspector$delegate;
    @NotNull
    private final Lazy dataFactory$delegate;
    @NotNull
    private final Lazy templateStatementBuilder$delegate;

    public DefaultJdbcDatabaseConfig(@NotNull DataSource dataSource, @NotNull JdbcDialect dialect) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        this.dialect = dialect;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID()");
        this.id = uUID;
        this.clockProvider = (ClockProvider)new DefaultClockProvider(null, 1, null);
        this.executionOptions = new ExecutionOptions(Integer.valueOf(10), null, null, null, null, 30, null);
        this.logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);
        this.loggerFacade$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DefaultLoggerFacade>(this){
            final /* synthetic */ DefaultJdbcDatabaseConfig this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DefaultLoggerFacade invoke() {
                return new DefaultLoggerFacade(this.this$0.getLogger());
            }
        }));
        this.session$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JdbcSession>(dataSource, this){
            final /* synthetic */ DataSource $dataSource;
            final /* synthetic */ DefaultJdbcDatabaseConfig this$0;
            {
                this.$dataSource = $dataSource;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final JdbcSession invoke() {
                return JdbcSessions.INSTANCE.get(this.$dataSource, this.this$0.getLoggerFacade());
            }
        }));
        this.statementInspector$delegate = LazyKt.lazy((Function0)statementInspector.2.INSTANCE);
        this.dataFactory$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DefaultJdbcDataFactory>(this){
            final /* synthetic */ DefaultJdbcDatabaseConfig this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DefaultJdbcDataFactory invoke() {
                return new DefaultJdbcDataFactory(this.this$0.getSession());
            }
        }));
        this.templateStatementBuilder$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TemplateStatementBuilder>(this){
            final /* synthetic */ DefaultJdbcDatabaseConfig this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final TemplateStatementBuilder invoke() {
                return TemplateStatementBuilders.INSTANCE.get((Dialect)this.this$0.getDialect());
            }
        }));
    }

    @Override
    @NotNull
    public JdbcDialect getDialect() {
        return this.dialect;
    }

    public DefaultJdbcDatabaseConfig(@NotNull String url, @NotNull String user, @NotNull String password, @NotNull List<? extends JdbcDataType<?>> dataTypes) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter(dataTypes, (String)"dataTypes");
        this(new SimpleDataSource(url, user, password), JdbcDialects.INSTANCE.getByUrl(url, dataTypes));
    }

    public /* synthetic */ DefaultJdbcDatabaseConfig(String string, String string2, String string3, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, string2, string3, list);
    }

    @NotNull
    public UUID getId() {
        return this.id;
    }

    @NotNull
    public ClockProvider getClockProvider() {
        return this.clockProvider;
    }

    @NotNull
    public ExecutionOptions getExecutionOptions() {
        return this.executionOptions;
    }

    @NotNull
    public Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public LoggerFacade getLoggerFacade() {
        Lazy lazy = this.loggerFacade$delegate;
        return (LoggerFacade)lazy.getValue();
    }

    @Override
    @NotNull
    public JdbcSession getSession() {
        Lazy lazy = this.session$delegate;
        return (JdbcSession)lazy.getValue();
    }

    @NotNull
    public StatementInspector getStatementInspector() {
        Lazy lazy = this.statementInspector$delegate;
        return (StatementInspector)lazy.getValue();
    }

    @Override
    @NotNull
    public JdbcDataFactory getDataFactory() {
        Lazy lazy = this.dataFactory$delegate;
        return (JdbcDataFactory)lazy.getValue();
    }

    @NotNull
    public TemplateStatementBuilder getTemplateStatementBuilder() {
        Lazy lazy = this.templateStatementBuilder$delegate;
        return (TemplateStatementBuilder)lazy.getValue();
    }
}

