/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.jdbc;

import java.util.ServiceLoader;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.komapper.core.LoggerFacade;
import org.komapper.core.spi.SpiUtilityKt;
import org.komapper.jdbc.DefaultJdbcSession;
import org.komapper.jdbc.JdbcSession;
import org.komapper.jdbc.spi.JdbcSessionFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/komapper/jdbc/JdbcSessions;", "", "()V", "get", "Lorg/komapper/jdbc/JdbcSession;", "dataSource", "Ljavax/sql/DataSource;", "loggerFacade", "Lorg/komapper/core/LoggerFacade;", "komapper-jdbc"})
public final class JdbcSessions {
    @NotNull
    public static final JdbcSessions INSTANCE = new JdbcSessions();

    private JdbcSessions() {
    }

    @NotNull
    public final JdbcSession get(@NotNull DataSource dataSource, @NotNull LoggerFacade loggerFacade2) {
        JdbcSessionFactory factory;
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)loggerFacade2, (String)"loggerFacade");
        ServiceLoader<JdbcSessionFactory> loader = ServiceLoader.load(JdbcSessionFactory.class);
        Intrinsics.checkNotNullExpressionValue(loader, (String)"loader");
        JdbcSessionFactory jdbcSessionFactory = factory = (JdbcSessionFactory)SpiUtilityKt.findByPriority((Iterable)loader);
        JdbcSession jdbcSession = jdbcSessionFactory == null ? null : jdbcSessionFactory.create(dataSource, loggerFacade2);
        if (jdbcSession == null) {
            jdbcSession = new DefaultJdbcSession(dataSource);
        }
        return jdbcSession;
    }
}

