/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.jdbc.dsl.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.komapper.core.DatabaseConfig;
import org.komapper.core.DryRunStatement;
import org.komapper.core.Statement;
import org.komapper.core.dsl.context.EntityInsertContext;
import org.komapper.core.dsl.metamodel.EntityMetamodel;
import org.komapper.core.dsl.runner.EntityInsertMultipleRunner;
import org.komapper.jdbc.JdbcDatabaseConfig;
import org.komapper.jdbc.JdbcExecutor;
import org.komapper.jdbc.dsl.runner.JdbcEntityInsertRunnerSupport;
import org.komapper.jdbc.dsl.runner.JdbcRunner;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0002*\u001a\b\u0002\u0010\u0004*\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u00052\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00070\u0006B-\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00072\u0006\u0010\u0012\u001a\u00020\u00182\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0002J*\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u0007H\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u0006\u0010\u0012\u001a\u00020\u0018H\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u0006\u0010\u0012\u001a\u00020\u0018H\u0016R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/komapper/jdbc/dsl/runner/JdbcEntityInsertMultipleRunner;", "ENTITY", "", "ID", "META", "Lorg/komapper/core/dsl/metamodel/EntityMetamodel;", "Lorg/komapper/jdbc/dsl/runner/JdbcRunner;", "", "context", "Lorg/komapper/core/dsl/context/EntityInsertContext;", "entities", "(Lorg/komapper/core/dsl/context/EntityInsertContext;Ljava/util/List;)V", "runner", "Lorg/komapper/core/dsl/runner/EntityInsertMultipleRunner;", "support", "Lorg/komapper/jdbc/dsl/runner/JdbcEntityInsertRunnerSupport;", "check", "", "config", "Lorg/komapper/core/DatabaseConfig;", "dryRun", "Lorg/komapper/core/DryRunStatement;", "insert", "", "Lorg/komapper/jdbc/JdbcDatabaseConfig;", "postInsert", "generatedKeys", "preInsert", "run", "komapper-jdbc"})
public final class JdbcEntityInsertMultipleRunner<ENTITY, ID, META extends EntityMetamodel<ENTITY, ID, META>>
implements JdbcRunner<List<? extends ENTITY>> {
    @NotNull
    private final List<ENTITY> entities;
    @NotNull
    private final EntityInsertMultipleRunner<ENTITY, ID, META> runner;
    @NotNull
    private final JdbcEntityInsertRunnerSupport<ENTITY, ID, META> support;

    public JdbcEntityInsertMultipleRunner(@NotNull EntityInsertContext<ENTITY, ID, META> context, @NotNull List<? extends ENTITY> entities) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        this.entities = entities;
        this.runner = new EntityInsertMultipleRunner(context, this.entities);
        this.support = new JdbcEntityInsertRunnerSupport<ENTITY, ID, META>(context);
    }

    public void check(@NotNull DatabaseConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.runner.check(config);
    }

    @Override
    @NotNull
    public List<ENTITY> run(@NotNull JdbcDatabaseConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (this.entities.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List<ENTITY> newEntities = this.preInsert(config);
        List<Long> generatedKeys = this.insert(config, newEntities);
        return this.postInsert(newEntities, generatedKeys);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ENTITY> preInsert(JdbcDatabaseConfig config) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.entities;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.support.preInsert(config, it));
        }
        return (List)destination$iv$iv;
    }

    private final List<Long> insert(JdbcDatabaseConfig config, List<? extends ENTITY> entities) {
        Statement statement = this.runner.buildStatement((DatabaseConfig)config, entities);
        List keys = (List)((Pair)this.support.insert(config, true, (Function1)new Function1<JdbcExecutor, Pair<? extends Integer, ? extends List<? extends Long>>>(statement){
            final /* synthetic */ Statement $statement;
            {
                this.$statement = $statement;
                super(1);
            }

            @NotNull
            public final Pair<Integer, List<Long>> invoke(@NotNull JdbcExecutor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.executeUpdate(this.$statement);
            }
        })).component2();
        return keys;
    }

    private final List<ENTITY> postInsert(List<? extends ENTITY> entities, List<Long> generatedKeys) {
        return this.runner.postInsert(entities, generatedKeys);
    }

    @NotNull
    public DryRunStatement dryRun(@NotNull DatabaseConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return this.runner.dryRun(config);
    }
}

