/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.jdbc.dsl.runner;

import java.time.Clock;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.komapper.core.ExecutionOptionsProvider;
import org.komapper.core.dsl.context.EntityInsertContext;
import org.komapper.core.dsl.metamodel.EntityMetamodel;
import org.komapper.core.dsl.metamodel.IdGenerator;
import org.komapper.core.dsl.metamodel.MetamodelUtilityKt;
import org.komapper.core.dsl.metamodel.PropertyMetamodel;
import org.komapper.core.dsl.options.QueryOptions;
import org.komapper.jdbc.JdbcDatabaseConfig;
import org.komapper.jdbc.JdbcExecutor;
import org.komapper.jdbc.dsl.runner.JdbcRunnerUtilityKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0002*\u001a\b\u0002\u0010\u0004*\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u00052\u00020\u0002B\u001f\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007\u00a2\u0006\u0002\u0010\bJ5\u0010\t\u001a\u0002H\n\"\u0004\b\u0003\u0010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u0002H\n0\u0010\u00a2\u0006\u0002\u0010\u0012J\u001b\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/komapper/jdbc/dsl/runner/JdbcEntityInsertRunnerSupport;", "ENTITY", "", "ID", "META", "Lorg/komapper/core/dsl/metamodel/EntityMetamodel;", "context", "Lorg/komapper/core/dsl/context/EntityInsertContext;", "(Lorg/komapper/core/dsl/context/EntityInsertContext;)V", "insert", "T", "config", "Lorg/komapper/jdbc/JdbcDatabaseConfig;", "usesGeneratedKeys", "", "execute", "Lkotlin/Function1;", "Lorg/komapper/jdbc/JdbcExecutor;", "(Lorg/komapper/jdbc/JdbcDatabaseConfig;ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "preInsert", "entity", "(Lorg/komapper/jdbc/JdbcDatabaseConfig;Ljava/lang/Object;)Ljava/lang/Object;", "komapper-jdbc"})
public final class JdbcEntityInsertRunnerSupport<ENTITY, ID, META extends EntityMetamodel<ENTITY, ID, META>> {
    @NotNull
    private final EntityInsertContext<ENTITY, ID, META> context;

    public JdbcEntityInsertRunnerSupport(@NotNull EntityInsertContext<ENTITY, ID, META> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final ENTITY preInsert(@NotNull JdbcDatabaseConfig config, @NotNull ENTITY entity) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        IdGenerator idGenerator = this.context.getTarget().idGenerator();
        if (idGenerator instanceof IdGenerator.Sequence) {
            if (!this.context.getTarget().disableSequenceAssignment() && !this.context.getOptions().getDisableSequenceAssignment()) {
                Object id = JdbcRunnerUtilityKt.execute((IdGenerator.Sequence)idGenerator, config, (QueryOptions)this.context.getOptions());
                object = ((IdGenerator.Sequence)idGenerator).getProperty().getSetter().invoke(entity, id);
            } else {
                object = null;
            }
        } else {
            object = null;
        }
        Object newEntity = object;
        Clock clock = config.getClockProvider().now();
        EntityMetamodel entityMetamodel = this.context.getTarget();
        Object object2 = newEntity;
        if (object2 == null) {
            object2 = entity;
        }
        return (ENTITY)entityMetamodel.preInsert(object2, clock);
    }

    public final <T> T insert(@NotNull JdbcDatabaseConfig config, boolean usesGeneratedKeys, @NotNull Function1<? super JdbcExecutor, ? extends T> execute2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(execute2, (String)"execute");
        if (usesGeneratedKeys && this.context.getOptions().getReturnGeneratedKeys()) {
            PropertyMetamodel propertyMetamodel = MetamodelUtilityKt.getAutoIncrementProperty((EntityMetamodel)this.context.getTarget());
            string = propertyMetamodel == null ? null : propertyMetamodel.getColumnName();
        } else {
            string = null;
        }
        String generatedColumn = string;
        JdbcExecutor executor = new JdbcExecutor(config, (ExecutionOptionsProvider)this.context.getOptions(), generatedColumn);
        return (T)execute2.invoke((Object)executor);
    }
}

