/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.jdbc.dsl.runner;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.komapper.core.DatabaseConfig;
import org.komapper.core.DryRunStatement;
import org.komapper.core.ExecutionOptionsProvider;
import org.komapper.core.Statement;
import org.komapper.core.dsl.context.SelectContext;
import org.komapper.core.dsl.metamodel.EntityMetamodel;
import org.komapper.core.dsl.query.EntityStore;
import org.komapper.core.dsl.runner.EntityStoreFactory;
import org.komapper.core.dsl.runner.SelectRunner;
import org.komapper.jdbc.JdbcDatabaseConfig;
import org.komapper.jdbc.JdbcExecutor;
import org.komapper.jdbc.dsl.runner.JdbcEntityMapper;
import org.komapper.jdbc.dsl.runner.JdbcRunner;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0002*\u001a\b\u0002\u0010\u0004*\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u00052\b\u0012\u0004\u0012\u00020\u00070\u0006B\u001f\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0016H\u0016R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/komapper/jdbc/dsl/runner/JdbcEntityStoreRunner;", "ENTITY", "", "ID", "META", "Lorg/komapper/core/dsl/metamodel/EntityMetamodel;", "Lorg/komapper/jdbc/dsl/runner/JdbcRunner;", "Lorg/komapper/core/dsl/query/EntityStore;", "context", "Lorg/komapper/core/dsl/context/SelectContext;", "(Lorg/komapper/core/dsl/context/SelectContext;)V", "factory", "Lorg/komapper/core/dsl/runner/EntityStoreFactory;", "runner", "Lorg/komapper/core/dsl/runner/SelectRunner;", "check", "", "config", "Lorg/komapper/core/DatabaseConfig;", "dryRun", "Lorg/komapper/core/DryRunStatement;", "run", "Lorg/komapper/jdbc/JdbcDatabaseConfig;", "komapper-jdbc"})
public final class JdbcEntityStoreRunner<ENTITY, ID, META extends EntityMetamodel<ENTITY, ID, META>>
implements JdbcRunner<EntityStore> {
    @NotNull
    private final SelectContext<ENTITY, ID, META> context;
    @NotNull
    private final SelectRunner runner;
    @NotNull
    private final EntityStoreFactory factory;

    public JdbcEntityStoreRunner(@NotNull SelectContext<ENTITY, ID, META> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        this.context = context;
        this.runner = new SelectRunner(this.context);
        this.factory = new EntityStoreFactory();
    }

    public void check(@NotNull DatabaseConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.runner.check(config);
    }

    @Override
    @NotNull
    public EntityStore run(@NotNull JdbcDatabaseConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Set metamodels = this.context.getProjection().metamodels();
        Statement statement = this.runner.buildStatement((DatabaseConfig)config);
        JdbcExecutor executor = new JdbcExecutor(config, (ExecutionOptionsProvider)this.context.getOptions(), null, 4, null);
        List rows2 = (List)executor.executeQuery(statement, (Function1)new Function1<ResultSet, List<Map<EntityMetamodel<?, ?, ?>, ? extends Object>>>(config, metamodels){
            final /* synthetic */ JdbcDatabaseConfig $config;
            final /* synthetic */ Set<EntityMetamodel<?, ?, ?>> $metamodels;
            {
                this.$config = $config;
                this.$metamodels = $metamodels;
                super(1);
            }

            @NotNull
            public final List<Map<EntityMetamodel<?, ?, ?>, Object>> invoke(@NotNull ResultSet rs) {
                Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
                List rows2 = new ArrayList<E>();
                while (rs.next()) {
                    Map row = new LinkedHashMap<K, V>();
                    JdbcEntityMapper mapper = new JdbcEntityMapper(this.$config.getDialect(), rs);
                    for (EntityMetamodel<?, ?, ?> metamodel : this.$metamodels) {
                        Object entity;
                        if (JdbcEntityMapper.execute$default(mapper, metamodel, false, 2, null) == null) continue;
                        row.put(metamodel, entity);
                    }
                    rows2.add(row);
                }
                return rows2;
            }
        });
        return this.factory.create(metamodels, rows2);
    }

    @NotNull
    public DryRunStatement dryRun(@NotNull DatabaseConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return this.runner.dryRun(config);
    }
}

