/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.jdbc.dsl.runner;

import java.time.Clock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.komapper.core.DatabaseConfig;
import org.komapper.core.DryRunStatement;
import org.komapper.core.ExecutionOptionsProvider;
import org.komapper.core.Statement;
import org.komapper.core.dsl.context.RelationUpdateContext;
import org.komapper.core.dsl.metamodel.EntityMetamodel;
import org.komapper.core.dsl.runner.RelationUpdateRunner;
import org.komapper.jdbc.JdbcDatabaseConfig;
import org.komapper.jdbc.JdbcExecutor;
import org.komapper.jdbc.dsl.runner.JdbcRunner;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0002*\u001a\b\u0002\u0010\u0004*\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u00052\b\u0012\u0004\u0012\u00020\u00070\u0006B\u001f\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0015\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/komapper/jdbc/dsl/runner/JdbcRelationUpdateRunner;", "ENTITY", "", "ID", "META", "Lorg/komapper/core/dsl/metamodel/EntityMetamodel;", "Lorg/komapper/jdbc/dsl/runner/JdbcRunner;", "", "context", "Lorg/komapper/core/dsl/context/RelationUpdateContext;", "(Lorg/komapper/core/dsl/context/RelationUpdateContext;)V", "runner", "Lorg/komapper/core/dsl/runner/RelationUpdateRunner;", "check", "", "config", "Lorg/komapper/core/DatabaseConfig;", "dryRun", "Lorg/komapper/core/DryRunStatement;", "run", "Lorg/komapper/jdbc/JdbcDatabaseConfig;", "(Lorg/komapper/jdbc/JdbcDatabaseConfig;)Ljava/lang/Integer;", "komapper-jdbc"})
public final class JdbcRelationUpdateRunner<ENTITY, ID, META extends EntityMetamodel<ENTITY, ID, META>>
implements JdbcRunner<Integer> {
    @NotNull
    private final RelationUpdateContext<ENTITY, ID, META> context;
    @NotNull
    private final RelationUpdateRunner<ENTITY, ID, META> runner;

    public JdbcRelationUpdateRunner(@NotNull RelationUpdateContext<ENTITY, ID, META> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        this.context = context;
        this.runner = new RelationUpdateRunner(this.context);
    }

    public void check(@NotNull DatabaseConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.runner.check(config);
    }

    @Override
    @NotNull
    public Integer run(@NotNull JdbcDatabaseConfig config) {
        int n;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Clock clock = config.getClockProvider().now();
        Pair updatedAtAssignment = this.context.getTarget().updatedAtAssignment(clock);
        Object result = this.runner.buildStatement-gIAlu-s((DatabaseConfig)config, updatedAtAssignment);
        Statement statement = (Statement)(Result.isFailure-impl((Object)result) ? null : result);
        if (statement != null) {
            int count;
            JdbcExecutor executor = new JdbcExecutor(config, (ExecutionOptionsProvider)this.context.getOptions(), null, 4, null);
            n = count = ((Number)executor.executeUpdate(statement).component1()).intValue();
        } else {
            n = 0;
        }
        return n;
    }

    @NotNull
    public DryRunStatement dryRun(@NotNull DatabaseConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return this.runner.dryRun(config);
    }
}

