/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.jdbc;

import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.komapper.jdbc.JdbcDataType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\r\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H$\u00a2\u0006\u0002\u0010\u0012J\u001f\u0010\r\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H$\u00a2\u0006\u0002\u0010\u0015J%\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001f\u0010\u001e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001f\u0010\u001e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J'\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0017\u0010 \u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006!"}, d2={"Lorg/komapper/jdbc/AbstractJdbcDataType;", "T", "", "Lorg/komapper/jdbc/JdbcDataType;", "klass", "Lkotlin/reflect/KClass;", "jdbcType", "Ljava/sql/JDBCType;", "(Lkotlin/reflect/KClass;Ljava/sql/JDBCType;)V", "getJdbcType", "()Ljava/sql/JDBCType;", "getKlass", "()Lkotlin/reflect/KClass;", "doGetValue", "rs", "Ljava/sql/ResultSet;", "index", "", "(Ljava/sql/ResultSet;I)Ljava/lang/Object;", "columnLabel", "", "(Ljava/sql/ResultSet;Ljava/lang/String;)Ljava/lang/Object;", "doSetValue", "", "ps", "Ljava/sql/PreparedStatement;", "value", "(Ljava/sql/PreparedStatement;ILjava/lang/Object;)V", "doToString", "(Ljava/lang/Object;)Ljava/lang/String;", "getValue", "setValue", "toString", "komapper-jdbc"})
public abstract class AbstractJdbcDataType<T>
implements JdbcDataType<T> {
    @NotNull
    private final KClass<T> klass;
    @NotNull
    private final JDBCType jdbcType;

    public AbstractJdbcDataType(@NotNull KClass<T> klass, @NotNull JDBCType jdbcType) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)jdbcType, (String)"jdbcType");
        this.klass = klass;
        this.jdbcType = jdbcType;
    }

    @Override
    @NotNull
    public KClass<T> getKlass() {
        return this.klass;
    }

    @Override
    @NotNull
    public JDBCType getJdbcType() {
        return this.jdbcType;
    }

    @Override
    @Nullable
    public T getValue(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        T value = this.doGetValue(rs, index);
        return rs.wasNull() ? null : (T)value;
    }

    @Override
    @Nullable
    public T getValue(@NotNull ResultSet rs, @NotNull String columnLabel) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        Intrinsics.checkNotNullParameter((Object)columnLabel, (String)"columnLabel");
        T value = this.doGetValue(rs, columnLabel);
        return rs.wasNull() ? null : (T)value;
    }

    @Nullable
    protected abstract T doGetValue(@NotNull ResultSet var1, int var2);

    @Nullable
    protected abstract T doGetValue(@NotNull ResultSet var1, @NotNull String var2);

    @Override
    public void setValue(@NotNull PreparedStatement ps, int index, @Nullable T value) {
        Intrinsics.checkNotNullParameter((Object)ps, (String)"ps");
        if (value == null) {
            Integer n = this.getJdbcType().getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"jdbcType.vendorTypeNumber");
            ps.setNull(index, ((Number)n).intValue());
        } else {
            this.doSetValue(ps, index, value);
        }
    }

    protected abstract void doSetValue(@NotNull PreparedStatement var1, int var2, @NotNull T var3);

    @Override
    @NotNull
    public String toString(@Nullable T value) {
        T t = value;
        return t == null ? "null" : this.doToString(t);
    }

    @NotNull
    public String doToString(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return value.toString();
    }
}

