/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.komapper.jdbc.JdbcDataOperator;
import org.komapper.jdbc.JdbcDataType;
import org.komapper.jdbc.JdbcDataTypeProvider;
import org.komapper.jdbc.JdbcDialect;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J9\u0010\u0007\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u0001H\t2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\t0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J(\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\t0\u0012\"\b\b\u0000\u0010\t*\u00020\n2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\t0\rH\u0016J\u0014\u0010\u0014\u001a\u00020\b2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J*\u0010\u0015\u001a\n\u0012\u0004\u0012\u0002H\t\u0018\u00010\u0012\"\b\b\u0000\u0010\t*\u00020\n2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\t0\rH\u0016J9\u0010\u0016\u001a\u0004\u0018\u0001H\t\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\t0\rH\u0016\u00a2\u0006\u0002\u0010\u001bJ9\u0010\u0016\u001a\u0004\u0018\u0001H\t\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\t0\rH\u0016\u00a2\u0006\u0002\u0010\u001dJA\u0010\u001e\u001a\u00020\u001f\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u000b\u001a\u0004\u0018\u0001H\t2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\t0\rH\u0016\u00a2\u0006\u0002\u0010\"R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/komapper/jdbc/DefaultJdbcDataOperator;", "Lorg/komapper/jdbc/JdbcDataOperator;", "dialect", "Lorg/komapper/jdbc/JdbcDialect;", "dataTypeProvider", "Lorg/komapper/jdbc/JdbcDataTypeProvider;", "(Lorg/komapper/jdbc/JdbcDialect;Lorg/komapper/jdbc/JdbcDataTypeProvider;)V", "formatValue", "", "T", "", "value", "valueClass", "Lkotlin/reflect/KClass;", "masking", "", "(Ljava/lang/Object;Lkotlin/reflect/KClass;Z)Ljava/lang/String;", "getDataType", "Lorg/komapper/jdbc/JdbcDataType;", "klass", "getDataTypeName", "getDataTypeOrNull", "getValue", "rs", "Ljava/sql/ResultSet;", "index", "", "(Ljava/sql/ResultSet;ILkotlin/reflect/KClass;)Ljava/lang/Object;", "columnLabel", "(Ljava/sql/ResultSet;Ljava/lang/String;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "setValue", "", "ps", "Ljava/sql/PreparedStatement;", "(Ljava/sql/PreparedStatement;ILjava/lang/Object;Lkotlin/reflect/KClass;)V", "komapper-jdbc"})
public final class DefaultJdbcDataOperator
implements JdbcDataOperator {
    @NotNull
    private final JdbcDialect dialect;
    @NotNull
    private final JdbcDataTypeProvider dataTypeProvider;

    public DefaultJdbcDataOperator(@NotNull JdbcDialect dialect, @NotNull JdbcDataTypeProvider dataTypeProvider) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)dataTypeProvider, (String)"dataTypeProvider");
        this.dialect = dialect;
        this.dataTypeProvider = dataTypeProvider;
    }

    @Override
    @Nullable
    public <T> T getValue(@NotNull ResultSet rs, int index, @NotNull KClass<? extends T> valueClass) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        Intrinsics.checkNotNullParameter(valueClass, (String)"valueClass");
        JdbcDataType<T> dataType = this.getDataType(valueClass);
        return dataType.getValue(rs, index);
    }

    @Override
    @Nullable
    public <T> T getValue(@NotNull ResultSet rs, @NotNull String columnLabel, @NotNull KClass<? extends T> valueClass) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        Intrinsics.checkNotNullParameter((Object)columnLabel, (String)"columnLabel");
        Intrinsics.checkNotNullParameter(valueClass, (String)"valueClass");
        JdbcDataType<T> dataType = this.getDataType(valueClass);
        return dataType.getValue(rs, columnLabel);
    }

    @Override
    public <T> void setValue(@NotNull PreparedStatement ps, int index, @Nullable T value, @NotNull KClass<? extends T> valueClass) {
        Intrinsics.checkNotNullParameter((Object)ps, (String)"ps");
        Intrinsics.checkNotNullParameter(valueClass, (String)"valueClass");
        JdbcDataType<T> dataType = this.getDataType(valueClass);
        dataType.setValue(ps, index, value);
    }

    @NotNull
    public <T> String formatValue(@Nullable T value, @NotNull KClass<? extends T> valueClass, boolean masking) {
        JdbcDataType<? extends T> jdbcDataType;
        Intrinsics.checkNotNullParameter(valueClass, (String)"valueClass");
        if (masking) {
            jdbcDataType = this.dialect.getMask();
        } else {
            JdbcDataType<? extends T> dataType = this.getDataTypeOrNull(valueClass);
            jdbcDataType = dataType;
            if (jdbcDataType == null || (jdbcDataType = jdbcDataType.toString((T)value)) == null) {
                jdbcDataType = String.valueOf(value);
            }
        }
        return jdbcDataType;
    }

    @NotNull
    public String getDataTypeName(@NotNull KClass<?> klass) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        JdbcDataType<?> dataType = this.getDataType(klass);
        return dataType.getName();
    }

    @Override
    @NotNull
    public <T> JdbcDataType<T> getDataType(@NotNull KClass<? extends T> klass) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        JdbcDataType<? extends T> jdbcDataType = this.getDataTypeOrNull(klass);
        if (jdbcDataType == null) {
            throw new IllegalStateException(("The dataType is not found for the type \"" + klass.getQualifiedName() + "\".").toString());
        }
        return jdbcDataType;
    }

    @Override
    @Nullable
    public <T> JdbcDataType<T> getDataTypeOrNull(@NotNull KClass<? extends T> klass) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        return this.dataTypeProvider.get(klass);
    }
}

