/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.jdbc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.komapper.jdbc.JdbcBigDecimalType;
import org.komapper.jdbc.JdbcDataType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0004H\u0016J\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u001d\u001a\u00020\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lorg/komapper/jdbc/JdbcBigIntegerType;", "Lorg/komapper/jdbc/JdbcDataType;", "Ljava/math/BigInteger;", "name", "", "(Ljava/lang/String;)V", "dataType", "Lorg/komapper/jdbc/JdbcBigDecimalType;", "jdbcType", "Ljava/sql/JDBCType;", "getJdbcType", "()Ljava/sql/JDBCType;", "klass", "Lkotlin/reflect/KClass;", "getKlass", "()Lkotlin/reflect/KClass;", "getName", "()Ljava/lang/String;", "getValue", "rs", "Ljava/sql/ResultSet;", "index", "", "columnLabel", "setValue", "", "ps", "Ljava/sql/PreparedStatement;", "value", "toString", "komapper-jdbc"})
public final class JdbcBigIntegerType
implements JdbcDataType<BigInteger> {
    @NotNull
    private final String name;
    @NotNull
    private final JdbcBigDecimalType dataType;
    @NotNull
    private final KClass<BigInteger> klass;
    @NotNull
    private final JDBCType jdbcType;

    public JdbcBigIntegerType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.dataType = new JdbcBigDecimalType(this.getName());
        this.klass = Reflection.getOrCreateKotlinClass(BigInteger.class);
        this.jdbcType = this.dataType.getJdbcType();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public KClass<BigInteger> getKlass() {
        return this.klass;
    }

    @Override
    @NotNull
    public JDBCType getJdbcType() {
        return this.jdbcType;
    }

    @Override
    @Nullable
    public BigInteger getValue(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        BigDecimal bigDecimal = (BigDecimal)this.dataType.getValue(rs, index);
        return bigDecimal != null ? bigDecimal.toBigInteger() : null;
    }

    @Override
    @Nullable
    public BigInteger getValue(@NotNull ResultSet rs, @NotNull String columnLabel) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        Intrinsics.checkNotNullParameter((Object)columnLabel, (String)"columnLabel");
        BigDecimal bigDecimal = (BigDecimal)this.dataType.getValue(rs, columnLabel);
        return bigDecimal != null ? bigDecimal.toBigInteger() : null;
    }

    @Override
    public void setValue(@NotNull PreparedStatement ps, int index, @Nullable BigInteger value) {
        Intrinsics.checkNotNullParameter((Object)ps, (String)"ps");
        this.dataType.setValue(ps, index, value != null ? new BigDecimal(value) : null);
    }

    @Override
    @NotNull
    public String toString(@Nullable BigInteger value) {
        return this.dataType.toString(value != null ? new BigDecimal(value) : null);
    }
}

